/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.workspace.cases.attachments;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import eu.medsea.mimeutil.MimeType;
import eu.medsea.mimeutil.MimeUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Date;
import java.util.Observable;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.specification.Specification;
import org.qi4j.api.structure.Module;
import org.qi4j.api.util.DateFunctions;
import org.qi4j.api.util.Iterables;
import org.qi4j.api.value.ValueBuilder;
import org.restlet.data.Disposition;
import org.restlet.data.Form;
import org.restlet.representation.InputRepresentation;
import org.restlet.representation.Representation;
import org.restlet.util.Series;
import se.streamsource.dci.restlet.client.CommandQueryClient;
import se.streamsource.dci.value.ResourceValue;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.dci.value.link.LinksValue;
import se.streamsource.streamflow.api.workspace.cases.attachment.AttachmentDTO;
import se.streamsource.streamflow.api.workspace.cases.attachment.UpdateAttachmentDTO;
import se.streamsource.streamflow.client.OperationException;
import se.streamsource.streamflow.client.util.Downloadable;
import se.streamsource.streamflow.client.util.EventListSynch;
import se.streamsource.streamflow.client.util.Refreshable;
import se.streamsource.streamflow.infrastructure.event.domain.DomainEvent;
import se.streamsource.streamflow.infrastructure.event.domain.TransactionDomainEvents;
import se.streamsource.streamflow.infrastructure.event.domain.source.EventStream;
import se.streamsource.streamflow.infrastructure.event.domain.source.TransactionListener;
import se.streamsource.streamflow.infrastructure.event.domain.source.helper.EventParameters;
import se.streamsource.streamflow.infrastructure.event.domain.source.helper.Events;

public class AttachmentsModel
extends Observable
implements Refreshable,
Downloadable {
    @Service
    EventStream eventStream;
    @Structure
    private Module module;
    @Uses
    private CommandQueryClient client;
    private EventList<AttachmentDTO> eventList = new BasicEventList();

    public EventList<AttachmentDTO> getEventList() {
        return this.eventList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createAttachment(final File file, InputStream in) throws IOException {
        InputRepresentation input = new InputRepresentation((InputStream)new BufferedInputStream(in));
        Form disposition = new Form();
        disposition.set("filename", file.getName());
        disposition.set("size", Long.toString(file.length()));
        disposition.set("creation-date", DateFunctions.toUtcString((Date)new Date(file.lastModified())));
        input.setDisposition(new Disposition("none", (Series)disposition));
        TransactionListener updateListener = new TransactionListener(){

            public void notifyTransactions(Iterable<TransactionDomainEvents> transactions) {
                for (DomainEvent domainEvent : Iterables.filter((Specification)Events.withNames((String[])new String[]{"createdAttachment"}), (Iterable)Events.events(transactions))) {
                    ValueBuilder builder = AttachmentsModel.this.module.valueBuilderFactory().newValueBuilder(UpdateAttachmentDTO.class);
                    ((UpdateAttachmentDTO)builder.prototype()).name().set((Object)file.getName());
                    ((UpdateAttachmentDTO)builder.prototype()).size().set((Object)file.length());
                    MimeUtil.registerMimeDetector((String)"eu.medsea.mimeutil.detector.MagicMimeMimeDetector");
                    MimeType mimeType = MimeUtil.getMostSpecificMimeType((Collection)MimeUtil.getMimeTypes((File)file));
                    ((UpdateAttachmentDTO)builder.prototype()).mimeType().set((Object)mimeType.toString());
                    String attachmentId = EventParameters.getParameter((DomainEvent)domainEvent, (String)"param1");
                    AttachmentsModel.this.client.getClient(attachmentId + "/").postCommand("update", builder.newInstance());
                }
            }
        };
        this.eventStream.registerListener(updateListener);
        try {
            this.client.postCommand("createattachment", (Object)input);
        }
        finally {
            this.eventStream.unregisterListener(updateListener);
        }
    }

    @Override
    public void refresh() throws OperationException {
        ResourceValue resource = this.client.query();
        LinksValue newRoot = (LinksValue)resource.index().get();
        EventListSynch.synchronize((Collection)newRoot.links().get(), this.eventList);
        this.setChanged();
        this.notifyObservers(resource);
    }

    public void removeAttachment(AttachmentDTO attachment) {
        this.client.getClient((LinkValue)attachment).delete();
    }

    @Override
    public Representation download(String relativePath) throws IOException {
        return (Representation)this.client.getClient(relativePath).query("download", Representation.class);
    }
}

