/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.workspace.cases;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdesktop.application.ApplicationContext;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Uses;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.streamflow.api.workspace.cases.CaseDTO;
import se.streamsource.streamflow.api.workspace.cases.CaseStates;
import se.streamsource.streamflow.api.workspace.cases.general.PermissionsDTO;
import se.streamsource.streamflow.client.ui.workspace.WorkspaceResources;
import se.streamsource.streamflow.client.ui.workspace.cases.CaseModel;
import se.streamsource.streamflow.client.ui.workspace.cases.CaseResources;
import se.streamsource.streamflow.client.ui.workspace.table.CaseStatusLabel;
import se.streamsource.streamflow.client.util.LinkedLabel;
import se.streamsource.streamflow.client.util.i18n;

public class CaseInfoView
extends JPanel
implements Observer {
    CaseModel model;
    private JLabel title = new JLabel("");
    private LinkedLabel caseType;
    private JLabel owner = new JLabel("");
    private JLabel assignedTo = new JLabel("");
    private JLabel createdBy = new JLabel("");
    private JLabel lock = new JLabel("");
    private CaseStatusLabel statusLabel = new CaseStatusLabel();

    public CaseInfoView(@Service ApplicationContext appContext, @Uses CaseModel model) {
        this.setActionMap((ActionMap)appContext.getActionMap((Object)this));
        this.caseType = new LinkedLabel();
        this.model = model;
        this.setFocusable(false);
        this.setFont(this.getFont().deriveFont(this.getFont().getSize() - 2));
        this.setPreferredSize(new Dimension(800, 50));
        this.setLayout(new BorderLayout());
        this.lock.setIcon(i18n.icon(CaseResources.case_unrestricted_icon));
        this.add((Component)this.lock, "West");
        JPanel topPanel = new JPanel();
        BoxLayout layout = new BoxLayout(topPanel, 0);
        topPanel.setLayout(layout);
        JLabel statusHeader = new JLabel(i18n.text(WorkspaceResources.case_status_header, new Object[0]));
        statusHeader.setFocusable(false);
        statusHeader.setForeground(Color.GRAY);
        this.statusLabel.setHorizontalAlignment(2);
        JLabel titleHeader = new JLabel(i18n.text(WorkspaceResources.case_separator, new Object[0]));
        titleHeader.setFocusable(false);
        titleHeader.setForeground(Color.GRAY);
        JLabel typeHeader = new JLabel(i18n.text(WorkspaceResources.casetype_column_header, new Object[0]));
        typeHeader.setFocusable(false);
        typeHeader.setForeground(Color.GRAY);
        JLabel ownerHeader = new JLabel(i18n.text(WorkspaceResources.owner, new Object[0]));
        ownerHeader.setFocusable(false);
        ownerHeader.setForeground(Color.GRAY);
        JLabel createdHeader = new JLabel(i18n.text(WorkspaceResources.created_by, new Object[0]));
        createdHeader.setFocusable(false);
        createdHeader.setForeground(Color.GRAY);
        JLabel assignedHeader = new JLabel(i18n.text(WorkspaceResources.assigned_to_header, new Object[0]));
        assignedHeader.setFocusable(false);
        assignedHeader.setForeground(Color.GRAY);
        this.addBox(topPanel, statusHeader, this.statusLabel);
        this.addBox(topPanel, titleHeader, this.title);
        this.addBox(topPanel, typeHeader, this.caseType);
        this.addBox(topPanel, ownerHeader, this.owner);
        this.addBox(topPanel, createdHeader, this.createdBy);
        this.addBox(topPanel, assignedHeader, this.assignedTo);
        this.add((Component)topPanel, "Center");
        model.addObserver(this);
    }

    private void addBox(JPanel container, JLabel label, JComponent component) {
        JPanel box = new JPanel();
        box.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
        box.setLayout(new BorderLayout());
        box.add((Component)label, "North");
        box.add((Component)component, "Center");
        container.add(box);
    }

    @Override
    public void update(Observable o, Object arg) {
        CaseDTO aCase = (CaseDTO)this.model.getIndex();
        if (((Boolean)aCase.restricted().get()).booleanValue()) {
            this.lock.setIcon(i18n.icon(CaseResources.case_restricted_icon));
        } else {
            this.lock.setIcon(i18n.icon(CaseResources.case_unrestricted_icon));
        }
        this.lock.setToolTipText(this.buildToolTipText(this.model.permissions()));
        this.statusLabel.setStatus((CaseStates)aCase.status().get(), (String)aCase.resolution().get());
        String titleText = (aCase.caseId().get() != null ? "#" + (String)aCase.caseId().get() + " " : "") + (String)aCase.text().get();
        this.title.setText(titleText);
        this.title.setToolTipText(titleText);
        String text = aCase.caseType().get() != null ? (String)((LinkValue)aCase.caseType().get()).text().get() + (aCase.resolution().get() != null ? "(" + (String)aCase.resolution().get() + ")" : "") : "";
        this.caseType.setLink((LinkValue)aCase.caseType().get(), text);
        String ownerText = (String)aCase.owner().get();
        this.owner.setText(ownerText);
        this.owner.setToolTipText(ownerText);
        String createdByText = (String)aCase.createdBy().get();
        this.createdBy.setText(createdByText);
        this.createdBy.setToolTipText(createdByText);
        this.assignedTo.setText(aCase.assignedTo().get() != null ? (String)aCase.assignedTo().get() : "");
        this.assignedTo.setToolTipText(this.assignedTo.getText());
    }

    private String buildToolTipText(PermissionsDTO permissions) {
        StringBuilder sb = new StringBuilder();
        String read = (String)permissions.readAccess().get();
        String write = (String)permissions.writeAccess().get();
        sb.append("<html><b>").append(i18n.text(WorkspaceResources.restrict, new Object[0])).append("</b><br>");
        sb.append(read.substring(0, 1).toUpperCase());
        sb.append(read.substring(1)).append("<br>");
        sb.append(write.substring(0, 1).toUpperCase());
        sb.append(write.substring(1)).append("</html>");
        return sb.toString();
    }
}

