/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.workspace.cases;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.Observable;
import java.util.Observer;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.specification.Specification;
import org.qi4j.api.structure.Module;
import se.streamsource.streamflow.api.workspace.cases.CaseDTO;
import se.streamsource.streamflow.client.Icons;
import se.streamsource.streamflow.client.StreamflowApplication;
import se.streamsource.streamflow.client.ui.workspace.WorkspaceResources;
import se.streamsource.streamflow.client.ui.workspace.cases.CaseActionsView;
import se.streamsource.streamflow.client.ui.workspace.cases.CaseInfoView;
import se.streamsource.streamflow.client.ui.workspace.cases.CaseModel;
import se.streamsource.streamflow.client.ui.workspace.cases.attachments.AttachmentsView;
import se.streamsource.streamflow.client.ui.workspace.cases.caselog.CaseLogView;
import se.streamsource.streamflow.client.ui.workspace.cases.contacts.ContactsAdminView;
import se.streamsource.streamflow.client.ui.workspace.cases.conversations.ConversationsView;
import se.streamsource.streamflow.client.ui.workspace.cases.forms.SubmittedFormsAdminView;
import se.streamsource.streamflow.client.ui.workspace.cases.general.CaseGeneralView;
import se.streamsource.streamflow.client.util.CommandTask;
import se.streamsource.streamflow.client.util.RefreshWhenShowing;
import se.streamsource.streamflow.client.util.i18n;
import se.streamsource.streamflow.infrastructure.event.domain.TransactionDomainEvents;
import se.streamsource.streamflow.infrastructure.event.domain.source.TransactionListener;
import se.streamsource.streamflow.infrastructure.event.domain.source.helper.Events;

public class CaseDetailView
extends JPanel
implements Observer,
TransactionListener,
HierarchyListener {
    private JTabbedPane tabs = new JTabbedPane(3);
    private CaseModel model;
    private CaseInfoView caseInfo;
    private CaseActionsView caseActions;
    private Timer timer;
    private TimerTask timerTask;

    public CaseDetailView(@Uses CaseModel model, @Structure Module module) {
        super(new BorderLayout());
        this.model = model;
        model.addObserver(this);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.tabs.setFocusable(true);
        this.caseInfo = (CaseInfoView)module.objectBuilderFactory().newObjectBuilder(CaseInfoView.class).use(new Object[]{model}).newInstance();
        this.add((Component)this.caseInfo, "North");
        this.caseActions = (CaseActionsView)module.objectBuilderFactory().newObjectBuilder(CaseActionsView.class).use(new Object[]{model}).newInstance();
        this.add((Component)this.caseActions, "East");
        CaseLogView caseLogView = (CaseLogView)module.objectBuilderFactory().newObjectBuilder(CaseLogView.class).use(new Object[]{model.newCaseLogModel()}).newInstance();
        this.tabs.addTab(i18n.text(WorkspaceResources.general_tab, new Object[0]), i18n.icon(Icons.general), (Component)module.objectBuilderFactory().newObjectBuilder(CaseGeneralView.class).use(new Object[]{model.newGeneralModel(), caseLogView}).newInstance(), i18n.text(WorkspaceResources.general_tab, new Object[0]));
        this.tabs.addTab(i18n.text(WorkspaceResources.contacts_tab, new Object[0]), i18n.icon(Icons.projects), (Component)module.objectBuilderFactory().newObjectBuilder(ContactsAdminView.class).use(new Object[]{model.newContactsModel()}).newInstance(), i18n.text(WorkspaceResources.contacts_tab, new Object[0]));
        this.tabs.addTab(i18n.text(WorkspaceResources.forms_tab, new Object[0]), i18n.icon(Icons.forms), (Component)module.objectBuilderFactory().newObjectBuilder(SubmittedFormsAdminView.class).use(new Object[]{model.newSubmittedFormsModel()}).newInstance(), i18n.text(WorkspaceResources.forms_tab, new Object[0]));
        this.tabs.addTab(i18n.text(WorkspaceResources.conversations_tab, new Object[0]), i18n.icon(Icons.conversations), (Component)module.objectBuilderFactory().newObjectBuilder(ConversationsView.class).use(new Object[]{model.newConversationsModel()}).newInstance(), i18n.text(WorkspaceResources.conversations_tab, new Object[0]));
        this.tabs.addTab(i18n.text(WorkspaceResources.attachments_tab, new Object[0]), i18n.icon(Icons.attachments), (Component)module.objectBuilderFactory().newObjectBuilder(AttachmentsView.class).use(new Object[]{model.newAttachmentsModel()}).newInstance(), i18n.text(WorkspaceResources.attachments_tab, new Object[0]));
        this.tabs.setMnemonicAt(0, 49);
        this.tabs.setMnemonicAt(1, 50);
        this.tabs.setMnemonicAt(2, 51);
        this.tabs.setMnemonicAt(3, 52);
        this.tabs.setMnemonicAt(4, 53);
        this.tabs.setFocusable(true);
        this.tabs.setFocusCycleRoot(true);
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                CaseDetailView.this.tabs.getSelectedComponent().requestFocusInWindow();
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                if (CaseDetailView.this.timerTask != null) {
                    CaseDetailView.this.timerTask.cancel();
                    CaseDetailView.this.timer.cancel();
                    CaseDetailView.this.timerTask = null;
                    CaseDetailView.this.timer = null;
                }
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }
        });
        this.add((Component)this.tabs, "Center");
        new RefreshWhenShowing(this, model);
        this.addHierarchyListener(this);
    }

    public void setSelectedTab(int index) {
        if (this.tabs.getSelectedIndex() != index) {
            this.tabs.setSelectedIndex(index);
        }
    }

    public int getSelectedTab() {
        return this.tabs.getSelectedIndex();
    }

    public void notifyTransactions(Iterable<TransactionDomainEvents> transactions) {
        if (Events.matches((Specification)Events.withNames((String[])new String[]{"changedOwner", "changedCaseType", "changedDescription", "assignedTo", "unassigned", "changedStatus", "createdMessageFromDraft", "submittedForm", "setUnread"}), transactions)) {
            this.model.refresh();
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        this.tabs.setIconAt(2, (Boolean)((CaseDTO)this.model.getIndex()).hasUnreadForm().get() != false ? i18n.icon(Icons.unreadforms) : i18n.icon(Icons.forms));
        this.tabs.setIconAt(3, (Boolean)((CaseDTO)this.model.getIndex()).hasUnreadConversation().get() != false ? i18n.icon(Icons.unreadconversations) : i18n.icon(Icons.conversations));
    }

    @Override
    public void hierarchyChanged(HierarchyEvent e) {
        if ((e.getChangeFlags() & 4L) > 0L && this.isShowing()) {
            if (this.model.getIndex() == null) {
                this.model.refresh();
            }
            if (((Boolean)((CaseDTO)this.model.getIndex()).unread().get()).booleanValue()) {
                this.timer = new Timer();
                this.timerTask = new TimerTask(){

                    @Override
                    public void run() {
                        new CommandTask(){

                            @Override
                            protected void command() throws Exception {
                                CaseDetailView.this.model.read();
                            }
                        }.execute();
                    }
                };
                this.timer.schedule(this.timerTask, ((StreamflowApplication)StreamflowApplication.getInstance()).markReadTimeout());
            }
        }
    }
}

