/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.workspace;

import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import com.jgoodies.forms.factories.Borders;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationAction;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.Task;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.structure.Module;
import se.streamsource.streamflow.api.workspace.PerspectiveDTO;
import se.streamsource.streamflow.client.MacOsUIWrapper;
import se.streamsource.streamflow.client.ui.ContextItem;
import se.streamsource.streamflow.client.ui.workspace.WorkspaceContextView;
import se.streamsource.streamflow.client.ui.workspace.WorkspaceModel;
import se.streamsource.streamflow.client.ui.workspace.WorkspaceResources;
import se.streamsource.streamflow.client.ui.workspace.search.ManagePerspectivesDialog;
import se.streamsource.streamflow.client.ui.workspace.search.SearchResultTableModel;
import se.streamsource.streamflow.client.ui.workspace.search.SearchView;
import se.streamsource.streamflow.client.ui.workspace.table.CasesTableFormatter;
import se.streamsource.streamflow.client.ui.workspace.table.CasesTableView;
import se.streamsource.streamflow.client.ui.workspace.table.CasesView;
import se.streamsource.streamflow.client.util.CommandTask;
import se.streamsource.streamflow.client.util.RoundedBorder;
import se.streamsource.streamflow.client.util.StreamflowButton;
import se.streamsource.streamflow.client.util.dialog.DialogService;
import se.streamsource.streamflow.client.util.dialog.NameDialog;
import se.streamsource.streamflow.client.util.i18n;
import se.streamsource.streamflow.infrastructure.event.domain.TransactionDomainEvents;
import se.streamsource.streamflow.infrastructure.event.domain.source.TransactionListener;
import se.streamsource.streamflow.util.Strings;

public class WorkspaceView
extends JPanel
implements TransactionListener {
    @Service
    DialogService dialogs;
    Module module;
    SearchResultTableModel searchResultTableModel;
    private WorkspaceContextView contextView;
    private JLabel selectedContext;
    private StreamflowButton selectContextButton;
    private StreamflowButton createCaseButton;
    private JDialog popup;
    private JPanel contextToolbar;
    private JPanel contextPanel;
    private CardLayout topLayout = new CardLayout();
    private CasesView casesView;
    private WorkspaceModel model;
    private SearchView searchView;
    private javax.swing.Action managePerspectives;
    private javax.swing.Action savePerspective;
    private CasesTableView casesTable;

    public WorkspaceView(final @Service ApplicationContext context, final @Structure Module module, final @Uses WorkspaceModel model) {
        this.module = module;
        this.model = model;
        this.setLayout(new BorderLayout());
        this.setBorder(Borders.createEmptyBorder((String)"2dlu, 2dlu, 2dlu, 2dlu"));
        this.getInputMap(2).put(KeyStroke.getKeyStroke(37, 512 + Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "selectTree");
        this.getInputMap(2).put(KeyStroke.getKeyStroke(38, 512 + Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "selectTable");
        this.getInputMap(2).put(KeyStroke.getKeyStroke(40, 512 + Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "selectDetails");
        this.setActionMap((ActionMap)context.getActionMap((Object)this));
        MacOsUIWrapper.convertAccelerators((ActionMap)context.getActionMap(WorkspaceView.class, (Object)this));
        ActionMap am = this.getActionMap();
        ApplicationAction managePerspectivesAction = (ApplicationAction)this.getActionMap().get("managePerspectives");
        this.managePerspectives = context.getActionMap().get((Object)"managePerspectives");
        this.managePerspectives.putValue("proxy", managePerspectivesAction);
        ApplicationAction savePerspectiveAction = (ApplicationAction)this.getActionMap().get("savePerspective");
        this.savePerspective = context.getActionMap().get((Object)"savePerspective");
        this.savePerspective.putValue("proxy", savePerspectiveAction);
        savePerspectiveAction.setEnabled(false);
        this.searchResultTableModel = model.newSearchModel();
        this.searchView = (SearchView)module.objectBuilderFactory().newObjectBuilder(SearchView.class).use(new Object[]{this.searchResultTableModel}).newInstance();
        this.casesView = (CasesView)module.objectBuilderFactory().newObjectBuilder(CasesView.class).use(new Object[]{model.newCasesModel(), this.searchView.getTextField()}).newInstance();
        javax.swing.Action createCaseAction = am.get("createCase");
        this.createCaseButton = new StreamflowButton(createCaseAction);
        this.createCaseButton.registerKeyboardAction(createCaseAction, (KeyStroke)createCaseAction.getValue("AcceleratorKey"), 2);
        javax.swing.Action refreshAction = am.get("refresh");
        StreamflowButton refreshButton = new StreamflowButton(refreshAction);
        refreshButton.registerKeyboardAction(refreshAction, (KeyStroke)refreshAction.getValue("AcceleratorKey"), 2);
        MacOsUIWrapper.convertAccelerators(this.getActionMap());
        JPanel topPanel = new JPanel(new BorderLayout());
        this.selectContextButton = new StreamflowButton(this.getActionMap().get("selectContext"));
        this.selectContextButton.setMargin(new Insets(3, 4, 1, 3));
        this.selectContextButton.setName("btnSelectContext");
        JPanel contextSelectionPanel = new JPanel(new FlowLayout(0, 0, 0));
        contextSelectionPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 0));
        contextSelectionPanel.add(this.selectContextButton);
        this.selectedContext = new JLabel();
        this.selectedContext.setFont(this.selectedContext.getFont().deriveFont(1));
        contextSelectionPanel.add(this.selectedContext);
        topPanel.add((Component)contextSelectionPanel, "West");
        this.contextToolbar = new JPanel();
        this.contextToolbar.add(this.createCaseButton);
        this.contextToolbar.add(refreshButton);
        topPanel.add((Component)this.contextToolbar, "East");
        this.contextToolbar.setVisible(false);
        topPanel.add((Component)this.searchView, "Center");
        this.searchView.setVisible(false);
        this.add((Component)topPanel, "North");
        this.add((Component)this.casesView, "Center");
        this.contextView = (WorkspaceContextView)module.objectBuilderFactory().newObjectBuilder(WorkspaceContextView.class).use(new Object[]{model}).newInstance();
        JList workspaceContextList = this.contextView.getWorkspaceContextList();
        workspaceContextList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    JList list = (JList)e.getSource();
                    try {
                        if (list.getSelectedValue() == null) {
                            WorkspaceView.this.casesView.clearCase();
                            return;
                        }
                        if (!(list.getSelectedValue() instanceof ContextItem)) {
                            return;
                        }
                    }
                    catch (IndexOutOfBoundsException e1) {
                        return;
                    }
                    ContextItem contextItem = (ContextItem)list.getSelectedValue();
                    if (contextItem != null) {
                        boolean isSearch = contextItem.getRelation().equals("search");
                        boolean isPerspective = contextItem.getRelation().equals("perspective");
                        CasesTableFormatter tableFormat = new CasesTableFormatter();
                        if (isPerspective) {
                            PerspectiveDTO perspectiveDTO = (PerspectiveDTO)contextItem.getClient().query("index", PerspectiveDTO.class);
                            String contextRel = (String)perspectiveDTO.context().get();
                            for (ContextItem item : WorkspaceView.this.contextView.getModel().getItems()) {
                                if (!contextRel.equals(item.getClient().getReference().toString())) continue;
                                contextItem = item;
                                isSearch = contextItem.getRelation().equals("search");
                                break;
                            }
                            WorkspaceView.this.casesTable = (CasesTableView)module.objectBuilderFactory().newObjectBuilder(CasesTableView.class).use(new Object[]{isSearch ? WorkspaceView.this.searchResultTableModel : contextItem.getClient(), tableFormat, isSearch ? WorkspaceView.this.searchView.getTextField() : null}).newInstance();
                            WorkspaceView.this.casesTable.getModel().setFilter(perspectiveDTO);
                            WorkspaceView.this.searchView.getTextField().setText((String)perspectiveDTO.query().get());
                            WorkspaceView.this.setContextString(contextItem, (String)perspectiveDTO.name().get());
                        } else {
                            WorkspaceView.this.casesTable = (CasesTableView)module.objectBuilderFactory().newObjectBuilder(CasesTableView.class).use(new Object[]{isSearch ? WorkspaceView.this.searchResultTableModel : model.newCasesTableModel(contextItem.getClient()), tableFormat, isSearch ? WorkspaceView.this.searchView.getTextField() : null}).newInstance();
                            WorkspaceView.this.searchView.getTextField().setText("");
                            WorkspaceView.this.searchResultTableModel.clearSearchString();
                            WorkspaceView.this.casesTable.getModel().clearFilter();
                            WorkspaceView.this.setContextString(contextItem, null);
                        }
                        WorkspaceView.this.searchView.setVisible(isSearch);
                        WorkspaceView.this.contextToolbar.setVisible(true);
                        WorkspaceView.this.casesView.showTable(WorkspaceView.this.casesTable);
                        WorkspaceView.this.createCaseButton.setVisible(WorkspaceView.this.casesTable.getModel().isCreateCaseEnabled());
                    } else {
                        WorkspaceView.this.setContextString(contextItem, null);
                    }
                    WorkspaceView.this.killPopup();
                }
            }
        });
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) > 0L) {
                    if (!WorkspaceView.this.isShowing()) {
                        WorkspaceView.this.killPopup();
                        context.getActionMap().get((Object)"managePerspectives").setEnabled(false);
                        context.getActionMap().get((Object)"savePerspective").setEnabled(false);
                    } else {
                        context.getActionMap().get((Object)"managePerspectives").setEnabled(true);
                    }
                }
            }
        });
    }

    public void openCase(String id) {
        this.contextView.refresh();
        this.contextView.getWorkspaceContextList().setSelectedIndex(1);
        ListEventListener listener = new ListEventListener(){
            boolean executed = false;

            public void listChanged(ListEvent listEvent) {
                if (!this.executed) {
                    WorkspaceView.this.casesView.getCaseTableView().getCaseTable().getSelectionModel().setSelectionInterval(0, 0);
                    this.executed = true;
                }
            }
        };
        this.searchResultTableModel.getEventList().addListEventListener(listener);
        this.searchResultTableModel.search(id);
    }

    private void setContextString(ContextItem contextItem, String perspective) {
        if (contextItem != null) {
            this.selectedContext.setOpaque(true);
            UIDefaults uiDefaults = UIManager.getDefaults();
            this.selectedContext.setBackground(uiDefaults.getColor("Menu.selectionBackground"));
            this.selectedContext.setForeground(uiDefaults.getColor("Menu.selectionForeground"));
            this.selectedContext.setBorder(new RoundedBorder());
            String text = "";
            text = contextItem.getGroup().equals("") ? text + contextItem.getName() : text + contextItem.getGroup() + " : " + contextItem.getName();
            text = Strings.empty((String)perspective) ? text : text + " : " + perspective;
            this.selectedContext.setText("  " + text + " ");
            FontMetrics fm = this.selectedContext.getFontMetrics(this.selectedContext.getFont());
            int width = fm.stringWidth(this.selectedContext.getText()) + 15;
            this.selectedContext.setPreferredSize(new Dimension(width, 22));
        } else {
            this.selectedContext.setOpaque(false);
            this.selectedContext.setBackground(this.selectedContext.getParent().getBackground());
            this.selectedContext.setForeground(this.selectedContext.getParent().getForeground());
            this.selectedContext.setText("");
        }
    }

    @Action
    public void selectContext() {
        if (this.popup == null) {
            final JFrame frame = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, this);
            this.popup = new JDialog(frame);
            this.popup.setUndecorated(true);
            this.popup.setModal(false);
            this.popup.setLayout(new BorderLayout());
            this.popup.add((Component)this.contextView, "Center");
            Point location = this.selectContextButton.getLocationOnScreen();
            this.popup.setBounds((int)location.getX(), (int)location.getY() + this.selectContextButton.getHeight(), this.contextView.getWidth(), this.contextView.getHeight());
            this.popup.pack();
            this.popup.setVisible(true);
            frame.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentMoved(ComponentEvent e) {
                    if (WorkspaceView.this.popup != null) {
                        WorkspaceView.this.killPopup();
                        frame.removeComponentListener(this);
                    }
                }
            });
        } else {
            this.killPopup();
        }
    }

    @Action
    public Task createCase() {
        return new CommandTask(){

            @Override
            public void command() throws Exception {
                WorkspaceView.this.casesTable.getModel().clearFilter();
                WorkspaceView.this.casesTable.getModel().createCase();
            }
        };
    }

    @Action
    public void refresh() {
        this.casesView.refresh();
    }

    @Action
    public void managePerspectives() {
        ManagePerspectivesDialog dialog = (ManagePerspectivesDialog)this.module.objectBuilderFactory().newObjectBuilder(ManagePerspectivesDialog.class).use(new Object[]{this.model.newPerspectivesModel()}).newInstance();
        this.dialogs.showButtonLessDialog(this, dialog, i18n.text(WorkspaceResources.manage_perspectives, new Object[0]));
    }

    @Action
    public Task savePerspective() {
        final NameDialog dialog = (NameDialog)this.module.objectBuilderFactory().newObject(NameDialog.class);
        this.dialogs.showOkCancelHelpDialog(this, dialog, i18n.text(WorkspaceResources.save_perspective, new Object[0]));
        if (!Strings.empty((String)dialog.name())) {
            return new CommandTask(){

                @Override
                public void command() throws Exception {
                    PerspectiveDTO perspective = WorkspaceView.this.casesView.getCaseTableView().getModel().getPerspective(dialog.name(), WorkspaceView.this.searchView.isVisible() ? WorkspaceView.this.searchView.getTextField().getText() : "");
                    WorkspaceView.this.model.newPerspectivesModel().savePerspective(perspective);
                }
            };
        }
        return null;
    }

    public void notifyTransactions(Iterable<TransactionDomainEvents> transactions) {
    }

    public void killPopup() {
        if (this.popup != null) {
            this.popup.setVisible(false);
            this.popup.dispose();
            this.popup = null;
        }
    }

    public WorkspaceContextView getWorkspaceContext() {
        return this.contextView;
    }
}

