/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.workspace;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.structure.Module;
import org.restlet.data.Reference;
import se.streamsource.dci.restlet.client.CommandQueryClient;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.dci.value.link.LinksValue;
import se.streamsource.streamflow.client.ResourceModel;
import se.streamsource.streamflow.client.ui.ContextItem;
import se.streamsource.streamflow.client.ui.workspace.WorkspaceResources;
import se.streamsource.streamflow.client.ui.workspace.cases.CasesModel;
import se.streamsource.streamflow.client.ui.workspace.search.PerspectivesModel;
import se.streamsource.streamflow.client.ui.workspace.search.SearchResultTableModel;
import se.streamsource.streamflow.client.ui.workspace.table.CasesTableModel;
import se.streamsource.streamflow.client.util.EventListSynch;
import se.streamsource.streamflow.client.util.i18n;

public class WorkspaceModel
extends ResourceModel {
    @Structure
    Module module;
    EventList<ContextItem> items = new BasicEventList();
    LinksValue caseCounts;

    public EventList<ContextItem> getItems() {
        return this.items;
    }

    @Override
    public synchronized void refresh() {
        super.refresh();
        ArrayList<ContextItem> list = new ArrayList<ContextItem>();
        LinksValue projects = (LinksValue)this.getResourceValue().index().get();
        for (LinkValue contextLink : (List)projects.links().get()) {
            if (((String)contextLink.rel().get()).equals("drafts")) {
                list.add(new ContextItem("", i18n.text(WorkspaceResources.drafts_node, new Object[0]), "draft", -1L, this.client.getClient(contextLink)));
                continue;
            }
            if (((String)contextLink.rel().get()).equals("search")) {
                list.add(new ContextItem("", i18n.text(WorkspaceResources.search_node, new Object[0]), "search", -1L, this.client.getClient(contextLink)));
                continue;
            }
            if (((String)contextLink.rel().get()).equals("perspective")) {
                list.add(new ContextItem("", (String)contextLink.text().get(), (String)contextLink.rel().get(), -1L, this.client.getClient(contextLink)));
                continue;
            }
            if (((String)contextLink.rel().get()).equals("inbox")) {
                list.add(new ContextItem((String)contextLink.text().get(), i18n.text(WorkspaceResources.inboxes_node, new Object[0]), "inbox", -1L, this.client.getClient(contextLink)));
                continue;
            }
            if (!((String)contextLink.rel().get()).equals("assignments")) continue;
            list.add(new ContextItem((String)contextLink.text().get(), i18n.text(WorkspaceResources.assignments_node, new Object[0]), "assign", -1L, this.client.getClient(contextLink)));
        }
        EventListSynch.synchronize(Collections.emptyList(), this.items);
        EventListSynch.synchronize(list, this.items);
        this.applyCounts();
    }

    public synchronized void refreshCounts() {
        this.caseCounts = (LinksValue)this.client.query("casecounts", LinksValue.class);
        this.applyCounts();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void applyCounts() {
        if (this.caseCounts != null) {
            block3: for (LinkValue linkValue : (List)this.caseCounts.links().get()) {
                this.items.getReadWriteLock().writeLock().lock();
                try {
                    for (int i = 0; i < this.items.size(); ++i) {
                        ContextItem item = (ContextItem)this.items.get(i);
                        Reference reference = item.getClient().getReference();
                        String ref = reference.getPath();
                        ref = ref.endsWith("user/drafts/") ? "user/drafts" : ref.substring(0, ref.length() - 1);
                        if (!ref.endsWith((String)linkValue.id().get())) continue;
                        item.setCount(Long.valueOf((String)linkValue.text().get()));
                        this.items.set(i, (Object)item);
                        continue block3;
                    }
                }
                finally {
                    this.items.getReadWriteLock().writeLock().unlock();
                }
            }
        }
    }

    public CasesModel newCasesModel() {
        return (CasesModel)this.module.objectBuilderFactory().newObjectBuilder(CasesModel.class).use(new Object[]{this.client.getSubClient("cases")}).newInstance();
    }

    public SearchResultTableModel newSearchModel() {
        return (SearchResultTableModel)this.module.objectBuilderFactory().newObjectBuilder(SearchResultTableModel.class).use(new Object[]{this.client.getSubClient("search")}).newInstance();
    }

    public PerspectivesModel newPerspectivesModel() {
        return (PerspectivesModel)this.module.objectBuilderFactory().newObjectBuilder(PerspectivesModel.class).use(new Object[]{this.client.getSubClient("perspectives")}).newInstance();
    }

    public CasesTableModel newCasesTableModel(CommandQueryClient client) {
        return (CasesTableModel)this.module.objectBuilderFactory().newObjectBuilder(CasesTableModel.class).use(new Object[]{client}).newInstance();
    }
}

