/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.overview;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.SeparatorList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.TextFilterator;
import ca.odell.glazedlists.matchers.MatcherEditor;
import ca.odell.glazedlists.swing.EventListModel;
import ca.odell.glazedlists.swing.TextComponentMatcherEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;
import org.jdesktop.application.ApplicationContext;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.structure.Module;
import se.streamsource.streamflow.client.ui.ContextItem;
import se.streamsource.streamflow.client.ui.ContextItemGroupComparator;
import se.streamsource.streamflow.client.ui.ContextItemListRenderer;
import se.streamsource.streamflow.client.ui.overview.OverviewModel;
import se.streamsource.streamflow.client.ui.workspace.cases.CasesModel;
import se.streamsource.streamflow.client.ui.workspace.table.CasesTableFormatter;
import se.streamsource.streamflow.client.ui.workspace.table.CasesTableView;
import se.streamsource.streamflow.client.ui.workspace.table.CasesView;
import se.streamsource.streamflow.client.util.RefreshWhenShowing;
import se.streamsource.streamflow.client.util.SeparatorContextItemListCellRenderer;

public class OverviewView
extends JPanel {
    private JList overviewList = new JList();
    private JSplitPane pane;
    private CasesView casesView;
    private OverviewModel model;

    public OverviewView(@Service ApplicationContext context, @Uses CasesModel casesModel, @Uses OverviewModel overviewModel, final @Structure Module module) {
        super(new BorderLayout());
        this.casesView = (CasesView)module.objectBuilderFactory().newObjectBuilder(CasesView.class).use(new Object[]{casesModel}).newInstance();
        this.casesView.setBlankPanel(new JPanel());
        this.model = overviewModel;
        JTextField filterField = new JTextField();
        SortedList sortedIssues = new SortedList(this.model.getItems(), (Comparator)new Comparator<ContextItem>(){

            @Override
            public int compare(ContextItem o1, ContextItem o2) {
                return o1.getGroup().compareTo(o2.getGroup());
            }
        });
        FilterList textFilteredIssues = new FilterList((EventList)sortedIssues, (MatcherEditor)new TextComponentMatcherEditor((JTextComponent)filterField, (TextFilterator)new TextFilterator<ContextItem>(){

            public void getFilterStrings(List<String> strings, ContextItem contextItem) {
                strings.add(contextItem.getGroup());
            }
        }));
        ContextItemGroupComparator comparator = new ContextItemGroupComparator();
        SeparatorList separatorList = new SeparatorList((EventList)textFilteredIssues, (Comparator)comparator, 1, 10000);
        this.overviewList.setModel(new EventListModel((EventList)separatorList));
        this.overviewList.getSelectionModel().setSelectionMode(0);
        this.overviewList.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "select");
        this.overviewList.getActionMap().put("select", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OverviewView.this.pane.getRightComponent().requestFocus();
            }
        });
        this.overviewList.setCellRenderer(new SeparatorContextItemListCellRenderer((ListCellRenderer)((Object)new ContextItemListRenderer())));
        JScrollPane workspaceScroll = new JScrollPane(this.overviewList, 20, 30);
        this.pane = new JSplitPane(1);
        this.pane.setDividerLocation(200);
        this.pane.setResizeWeight(0.0);
        JPanel overviewOutline = new JPanel(new BorderLayout());
        overviewOutline.add((Component)workspaceScroll, "Center");
        overviewOutline.setMinimumSize(new Dimension(150, 300));
        this.pane.setLeftComponent(overviewOutline);
        this.pane.setRightComponent(this.casesView);
        this.add((Component)this.pane, "Center");
        this.overviewList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    JList list = (JList)e.getSource();
                    if (list.getSelectedValue() == null) {
                        return;
                    }
                    if (list.getSelectedValue() instanceof ContextItem) {
                        ContextItem contextItem = (ContextItem)list.getSelectedValue();
                        CasesTableFormatter tableFormat = new CasesTableFormatter();
                        CasesTableView casesTable = (CasesTableView)module.objectBuilderFactory().newObjectBuilder(CasesTableView.class).use(new Object[]{contextItem.getClient(), tableFormat}).newInstance();
                        OverviewView.this.casesView.showTable(casesTable);
                    }
                }
            }
        });
        new RefreshWhenShowing(this, this.model);
    }
}

