/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.administration.surface;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.ActionMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.swingx.util.WindowUtils;
import org.qi4j.api.constraint.ConstraintViolationException;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.structure.Module;
import org.qi4j.api.value.ValueBuilder;
import se.streamsource.streamflow.api.ErrorResources;
import se.streamsource.streamflow.api.administration.NewProxyUserDTO;
import se.streamsource.streamflow.client.ui.administration.AdministrationResources;
import se.streamsource.streamflow.client.util.dialog.DialogService;
import se.streamsource.streamflow.client.util.i18n;

public class CreateProxyUserDialog
extends JPanel {
    public JTextField descriptionField;
    public JPasswordField passwordField;
    @Uses
    DialogService dialogs;
    @Structure
    Module module;
    private NewProxyUserDTO DTO;

    public CreateProxyUserDialog(@Service ApplicationContext context) {
        super(new BorderLayout());
        FormLayout layout = new FormLayout("60dlu, 5dlu, 120dlu:grow", "pref, pref, pref, pref, 10dlu, pref, pref, pref, pref");
        JPanel form = new JPanel((LayoutManager)layout);
        form.setFocusable(false);
        DefaultFormBuilder builder = new DefaultFormBuilder(layout, form);
        this.descriptionField = new JTextField();
        this.passwordField = new JPasswordField();
        builder.add((Component)new JLabel(i18n.text(AdministrationResources.description_label, new Object[0])));
        builder.nextColumn(2);
        builder.add((Component)this.descriptionField);
        builder.nextLine();
        builder.add((Component)new JLabel(i18n.text(AdministrationResources.password_label, new Object[0])));
        builder.nextColumn(2);
        builder.add((Component)this.passwordField);
        builder.nextLine(2);
        this.setActionMap((ActionMap)context.getActionMap((Object)this));
        this.add((Component)form, "Center");
    }

    public NewProxyUserDTO userCommand() {
        return this.DTO;
    }

    @Action
    public void execute() {
        ValueBuilder builder = this.module.valueBuilderFactory().newValueBuilder(NewProxyUserDTO.class);
        try {
            ((NewProxyUserDTO)builder.prototype()).description().set((Object)this.descriptionField.getText());
            ((NewProxyUserDTO)builder.prototype()).password().set((Object)String.valueOf(this.passwordField.getPassword()));
            this.DTO = (NewProxyUserDTO)builder.newInstance();
        }
        catch (ConstraintViolationException e) {
            this.dialogs.showOkCancelHelpDialog(WindowUtils.findWindow((Component)this), new JLabel(i18n.text((Enum)ErrorResources.username_password_violation, new Object[0])));
            return;
        }
        WindowUtils.findWindow((Component)this).dispose();
    }

    @Action
    public void close() {
        WindowUtils.findWindow((Component)this).dispose();
    }
}

