/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.administration.projectsettings;

import ca.odell.glazedlists.swing.EventListModel;
import com.jgoodies.forms.factories.Borders;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.ActionMap;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.Task;
import org.jdesktop.swingx.JXList;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.specification.Specification;
import org.qi4j.api.structure.Module;
import org.qi4j.api.util.Iterables;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.streamflow.client.StreamflowResources;
import se.streamsource.streamflow.client.ui.administration.AdministrationResources;
import se.streamsource.streamflow.client.ui.administration.projectsettings.RecipientsModel;
import se.streamsource.streamflow.client.util.CommandTask;
import se.streamsource.streamflow.client.util.LinkListCellRenderer;
import se.streamsource.streamflow.client.util.RefreshWhenShowing;
import se.streamsource.streamflow.client.util.SelectionActionEnabler;
import se.streamsource.streamflow.client.util.StreamflowButton;
import se.streamsource.streamflow.client.util.dialog.ConfirmationDialog;
import se.streamsource.streamflow.client.util.dialog.DialogService;
import se.streamsource.streamflow.client.util.dialog.SelectLinkDialog;
import se.streamsource.streamflow.client.util.i18n;
import se.streamsource.streamflow.infrastructure.event.domain.TransactionDomainEvents;
import se.streamsource.streamflow.infrastructure.event.domain.source.TransactionListener;
import se.streamsource.streamflow.infrastructure.event.domain.source.helper.Events;

public class RecipientsView
extends JPanel
implements TransactionListener {
    @Service
    DialogService dialogs;
    @Structure
    Module module;
    public JXList recipientsList;
    private RecipientsModel model;

    public RecipientsView(@Service ApplicationContext context, @Uses RecipientsModel model) {
        super(new BorderLayout());
        this.model = model;
        this.setBorder(Borders.createEmptyBorder((String)"2dlu, 2dlu, 2dlu, 2dlu"));
        this.setActionMap((ActionMap)context.getActionMap((Object)this));
        this.recipientsList = new JXList((ListModel)new EventListModel(model.getList()));
        this.recipientsList.setCellRenderer((ListCellRenderer)new LinkListCellRenderer());
        this.add((Component)new JScrollPane((Component)this.recipientsList), "Center");
        JPanel toolbar = new JPanel();
        toolbar.add(new StreamflowButton(this.getActionMap().get("add")));
        toolbar.add(new StreamflowButton(this.getActionMap().get("remove")));
        this.add((Component)toolbar, "South");
        this.recipientsList.getSelectionModel().addListSelectionListener(new SelectionActionEnabler(this.getActionMap().get("remove")));
        new RefreshWhenShowing(this, model);
    }

    @Action
    public Task add() {
        final SelectLinkDialog dialog = (SelectLinkDialog)this.module.objectBuilderFactory().newObjectBuilder(SelectLinkDialog.class).use(new Object[]{this.model.getPossibleRecipients()}).newInstance();
        this.dialogs.showOkCancelHelpDialog(this, dialog, i18n.text(AdministrationResources.dueon_notification_add_recipient, new Object[0]));
        if (dialog.getSelectedLinks() != null && dialog.getSelectedLink() != null) {
            return new CommandTask(){

                @Override
                public void command() throws Exception {
                    RecipientsView.this.model.addRecipient(dialog.getSelectedLink());
                }
            };
        }
        return null;
    }

    @Action
    public Task remove() {
        final Iterable selected = Iterables.iterable((Object[])this.recipientsList.getSelectedValues());
        ConfirmationDialog dialog = (ConfirmationDialog)this.module.objectBuilderFactory().newObject(ConfirmationDialog.class);
        String str = "";
        for (LinkValue linkValue : selected) {
            str = str + (String)linkValue.text().get() + " ";
        }
        dialog.setRemovalMessage(str);
        this.dialogs.showOkCancelHelpDialog(this, dialog, i18n.text(StreamflowResources.confirmation, new Object[0]));
        if (dialog.isConfirmed()) {
            return new CommandTask(){

                @Override
                public void command() throws Exception {
                    for (LinkValue linkValue : selected) {
                        RecipientsView.this.model.removeRecipient(linkValue);
                    }
                }
            };
        }
        return null;
    }

    public void notifyTransactions(Iterable<TransactionDomainEvents> transactions) {
        if (Events.matches((Specification)Events.withNames((String[])new String[]{"changedNotificationSettings"}), transactions)) {
            this.model.refresh();
            this.recipientsList.clearSelection();
        }
    }
}

