/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.administration.projects;

import ca.odell.glazedlists.swing.EventListModel;
import com.jgoodies.forms.factories.Borders;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Set;
import javax.swing.ActionMap;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.Task;
import org.jdesktop.swingx.JXList;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.structure.Module;
import org.qi4j.api.util.Iterables;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.streamflow.client.StreamflowResources;
import se.streamsource.streamflow.client.ui.SelectUsersAndGroupsDialog;
import se.streamsource.streamflow.client.ui.administration.AdministrationResources;
import se.streamsource.streamflow.client.ui.administration.UsersAndGroupsModel;
import se.streamsource.streamflow.client.ui.administration.projects.MembersModel;
import se.streamsource.streamflow.client.util.CommandTask;
import se.streamsource.streamflow.client.util.LinkListCellRenderer;
import se.streamsource.streamflow.client.util.RefreshWhenShowing;
import se.streamsource.streamflow.client.util.SelectionActionEnabler;
import se.streamsource.streamflow.client.util.StreamflowButton;
import se.streamsource.streamflow.client.util.dialog.ConfirmationDialog;
import se.streamsource.streamflow.client.util.dialog.DialogService;
import se.streamsource.streamflow.client.util.i18n;
import se.streamsource.streamflow.infrastructure.event.domain.TransactionDomainEvents;
import se.streamsource.streamflow.infrastructure.event.domain.source.TransactionListener;

public class MembersView
extends JPanel
implements TransactionListener {
    @Service
    DialogService dialogs;
    @Structure
    Module module;
    private UsersAndGroupsModel usersAndGroupsModel;
    public JXList membersList;
    private MembersModel membersModel;

    public MembersView(@Service ApplicationContext context, @Uses MembersModel model) {
        super(new BorderLayout());
        this.membersModel = model;
        this.setBorder(Borders.createEmptyBorder((String)"2dlu, 2dlu, 2dlu, 2dlu"));
        this.usersAndGroupsModel = this.membersModel.newUsersAndGroupsModel();
        this.setActionMap((ActionMap)context.getActionMap((Object)this));
        this.membersList = new JXList((ListModel)new EventListModel(this.membersModel.getList()));
        this.membersList.setCellRenderer((ListCellRenderer)new LinkListCellRenderer());
        this.add((Component)new JScrollPane((Component)this.membersList), "Center");
        JPanel toolbar = new JPanel();
        toolbar.add(new StreamflowButton(this.getActionMap().get("add")));
        toolbar.add(new StreamflowButton(this.getActionMap().get("remove")));
        this.add((Component)toolbar, "South");
        this.membersList.getSelectionModel().addListSelectionListener(new SelectionActionEnabler(this.getActionMap().get("remove")));
        new RefreshWhenShowing(this, this.membersModel);
    }

    @Action
    public Task add() {
        SelectUsersAndGroupsDialog dialog = (SelectUsersAndGroupsDialog)this.module.objectBuilderFactory().newObjectBuilder(SelectUsersAndGroupsDialog.class).use(new Object[]{this.usersAndGroupsModel}).newInstance();
        this.dialogs.showOkCancelHelpDialog(this, dialog, i18n.text(AdministrationResources.add_user_or_group_title, new Object[0]));
        final Set<LinkValue> linkValueSet = dialog.getSelectedEntities();
        if (!linkValueSet.isEmpty()) {
            return new CommandTask(){

                @Override
                public void command() throws Exception {
                    MembersView.this.membersModel.add(linkValueSet);
                }
            };
        }
        return null;
    }

    @Action
    public Task remove() {
        final Iterable selected = Iterables.iterable((Object[])this.membersList.getSelectedValues());
        ConfirmationDialog dialog = (ConfirmationDialog)this.module.objectBuilderFactory().newObject(ConfirmationDialog.class);
        String str = "";
        for (LinkValue linkValue : selected) {
            str = str + (String)linkValue.text().get() + " ";
        }
        dialog.setRemovalMessage(str);
        this.dialogs.showOkCancelHelpDialog(this, dialog, i18n.text(StreamflowResources.confirmation, new Object[0]));
        if (dialog.isConfirmed()) {
            return new CommandTask(){

                @Override
                public void command() throws Exception {
                    for (LinkValue linkValue : selected) {
                        MembersView.this.membersModel.remove(linkValue);
                    }
                }
            };
        }
        return null;
    }

    public void notifyTransactions(Iterable<TransactionDomainEvents> transactions) {
        this.membersModel.notifyTransactions(transactions);
    }
}

