/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.administration.labels;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.SeparatorList;
import ca.odell.glazedlists.swing.EventListModel;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Comparator;
import javax.swing.ActionMap;
import javax.swing.JList;
import javax.swing.ListModel;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.Task;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.structure.Module;
import se.streamsource.dci.value.ResourceValue;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.streamflow.client.StreamflowResources;
import se.streamsource.streamflow.client.ui.administration.AdministrationResources;
import se.streamsource.streamflow.client.ui.administration.labels.LabelModel;
import se.streamsource.streamflow.client.ui.administration.labels.LabelsModel;
import se.streamsource.streamflow.client.util.CommandTask;
import se.streamsource.streamflow.client.util.LinkListCellRenderer;
import se.streamsource.streamflow.client.util.ListDetailView;
import se.streamsource.streamflow.client.util.RefreshWhenShowing;
import se.streamsource.streamflow.client.util.ResourceActionEnabler;
import se.streamsource.streamflow.client.util.SeparatorListCellRenderer;
import se.streamsource.streamflow.client.util.TabbedResourceView;
import se.streamsource.streamflow.client.util.TitledLinkGroupingComparator;
import se.streamsource.streamflow.client.util.dialog.ConfirmationDialog;
import se.streamsource.streamflow.client.util.dialog.DialogService;
import se.streamsource.streamflow.client.util.dialog.NameDialog;
import se.streamsource.streamflow.client.util.dialog.SelectLinkDialog;
import se.streamsource.streamflow.client.util.i18n;
import se.streamsource.streamflow.infrastructure.event.domain.TransactionDomainEvents;
import se.streamsource.streamflow.util.Strings;

public class LabelsView
extends ListDetailView {
    LabelsModel model;
    @Structure
    Module module;
    @Service
    DialogService dialogs;

    public LabelsView(@Service ApplicationContext context, final @Uses LabelsModel model) {
        this.model = model;
        ApplicationActionMap am = context.getActionMap((Object)this);
        this.setActionMap((ActionMap)am);
        this.initMaster((EventListModel<LinkValue>)new EventListModel(model.getList()), am.get("add"), new javax.swing.Action[]{am.get("move"), am.get("rename"), am.get("showUsages"), am.get("knowledgeBase"), am.get("remove")}, new ListDetailView.DetailFactory((ActionMap)am){
            final /* synthetic */ ActionMap val$am;
            {
                this.val$am = actionMap;
            }

            @Override
            public Component createDetail(LinkValue detailLink) {
                final LabelModel labelModel = (LabelModel)model.newResourceModel(detailLink);
                new ResourceActionEnabler(new javax.swing.Action[]{this.val$am.get("knowledgeBase")}){

                    @Override
                    protected ResourceValue getResource() {
                        labelModel.refresh();
                        return labelModel.getResourceValue();
                    }
                }.refresh();
                TabbedResourceView view = (TabbedResourceView)LabelsView.this.module.objectBuilderFactory().newObjectBuilder(TabbedResourceView.class).use(new Object[]{labelModel}).newInstance();
                return view;
            }
        });
        new RefreshWhenShowing(this, model);
    }

    @Action
    public Task add() {
        final NameDialog dialog = (NameDialog)this.module.objectBuilderFactory().newObject(NameDialog.class);
        this.dialogs.showOkCancelHelpDialog(this, dialog, i18n.text(AdministrationResources.add_label_title, new Object[0]));
        if (!Strings.empty((String)dialog.name())) {
            return new CommandTask(){

                @Override
                public void command() throws Exception {
                    LabelsView.this.model.create(dialog.name());
                }
            };
        }
        return null;
    }

    @Action
    public Task remove() {
        final LinkValue selected = (LinkValue)this.list.getSelectedValue();
        ConfirmationDialog dialog = (ConfirmationDialog)this.module.objectBuilderFactory().newObject(ConfirmationDialog.class);
        dialog.setRemovalMessage((String)selected.text().get());
        this.dialogs.showOkCancelHelpDialog(this, dialog, i18n.text(StreamflowResources.confirmation, new Object[0]));
        if (dialog.isConfirmed()) {
            return new CommandTask(){

                @Override
                public void command() throws Exception {
                    LabelsView.this.model.remove(selected);
                }
            };
        }
        return null;
    }

    @Action
    public Task move() {
        final LinkValue selected = (LinkValue)this.list.getSelectedValue();
        final SelectLinkDialog dialog = (SelectLinkDialog)this.module.objectBuilderFactory().newObjectBuilder(SelectLinkDialog.class).use(new Object[]{this.model.getPossibleMoveTo(selected)}).newInstance();
        dialog.setPreferredSize(new Dimension(200, 300));
        this.dialogs.showOkCancelHelpDialog(this, dialog, i18n.text(AdministrationResources.choose_move_label_to, new Object[0]));
        if (dialog.getSelectedLink() != null) {
            return new CommandTask(){

                @Override
                public void command() throws Exception {
                    LabelsView.this.model.moveForm(selected, dialog.getSelectedLink());
                }
            };
        }
        return null;
    }

    @Action
    public void showUsages() {
        LinkValue item = (LinkValue)this.list.getSelectedValue();
        SeparatorList separatorList = new SeparatorList(this.model.usages(item), (Comparator)new TitledLinkGroupingComparator(), 1, 10000);
        JList<Object> list = new JList<Object>();
        list.setCellRenderer(new SeparatorListCellRenderer(new LinkListCellRenderer()));
        list.setModel((ListModel<Object>)new EventListModel((EventList)separatorList));
        this.dialogs.showOkDialog(this, list);
        separatorList.dispose();
    }

    @Action
    public void knowledgeBase() throws URISyntaxException, IOException {
        LinkValue selected = (LinkValue)this.list.getSelectedValue();
        LinkValue url = this.model.getKnowledgeBaseLink(selected);
        Desktop.getDesktop().browse(new URI((String)url.href().get()));
    }

    @Action
    public Task rename() {
        final LinkValue selected = (LinkValue)this.list.getSelectedValue();
        final NameDialog dialog = (NameDialog)this.module.objectBuilderFactory().newObject(NameDialog.class);
        this.dialogs.showOkCancelHelpDialog(this, dialog, i18n.text(AdministrationResources.rename_label_title, new Object[0]));
        if (!Strings.empty((String)dialog.name())) {
            return new CommandTask(){

                @Override
                public void command() throws Exception {
                    LabelsView.this.model.changeDescription(selected, dialog.name());
                }
            };
        }
        return null;
    }

    @Override
    public void notifyTransactions(Iterable<TransactionDomainEvents> transactions) {
        this.model.notifyTransactions(transactions);
        super.notifyTransactions(transactions);
    }
}

