/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.administration.forms.definition;

import ca.odell.glazedlists.swing.EventListModel;
import com.jgoodies.forms.factories.Borders;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.ActionMap;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.Task;
import org.jdesktop.swingx.JXList;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.structure.Module;
import se.streamsource.streamflow.client.StreamflowResources;
import se.streamsource.streamflow.client.ui.administration.AdministrationResources;
import se.streamsource.streamflow.client.ui.administration.forms.definition.SelectionElementsModel;
import se.streamsource.streamflow.client.ui.workspace.WorkspaceResources;
import se.streamsource.streamflow.client.util.CommandTask;
import se.streamsource.streamflow.client.util.FileNameExtensionFilter;
import se.streamsource.streamflow.client.util.SelectionActionEnabler;
import se.streamsource.streamflow.client.util.StreamflowButton;
import se.streamsource.streamflow.client.util.dialog.ConfirmationDialog;
import se.streamsource.streamflow.client.util.dialog.DialogService;
import se.streamsource.streamflow.client.util.dialog.NameDialog;
import se.streamsource.streamflow.client.util.i18n;
import se.streamsource.streamflow.infrastructure.event.domain.TransactionDomainEvents;
import se.streamsource.streamflow.infrastructure.event.domain.source.TransactionListener;
import se.streamsource.streamflow.util.Strings;

public class SelectionElementsView
extends JPanel
implements TransactionListener {
    private JXList elementList;
    private StreamflowButton upButton;
    private StreamflowButton downButton;
    private SelectionElementsModel model;
    private ActionMap am;
    @Service
    DialogService dialogs;
    @Structure
    Module module;

    public SelectionElementsView(@Service ApplicationContext context, @Uses SelectionElementsModel model) {
        super(new BorderLayout());
        this.model = model;
        this.setBorder(Borders.createEmptyBorder((String)"4dlu, 4dlu, 4dlu, 4dlu"));
        JScrollPane scrollPanel = new JScrollPane();
        this.am = context.getActionMap((Object)this);
        JPanel toolbar = new JPanel();
        toolbar.add(new StreamflowButton(this.am.get("add")));
        toolbar.add(new StreamflowButton(this.am.get("remove")));
        this.upButton = new StreamflowButton(this.am.get("up"));
        toolbar.add(this.upButton);
        this.downButton = new StreamflowButton(this.am.get("down"));
        toolbar.add(this.downButton);
        this.upButton.setEnabled(false);
        this.downButton.setEnabled(false);
        toolbar.add(new StreamflowButton(this.am.get("rename")));
        toolbar.add(new StreamflowButton(this.am.get("importvalues")));
        toolbar.add(new StreamflowButton(this.am.get("removeall")));
        model.refresh();
        this.elementList = new JXList((ListModel)new EventListModel(model.getEventList()));
        this.elementList.setCellRenderer((ListCellRenderer)new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList jList, Object o, int i, boolean b, boolean b1) {
                if ("".equals(o)) {
                    Component cell = super.getListCellRendererComponent((JList<?>)jList, i18n.text(WorkspaceResources.name_label, new Object[0]), i, b, b1);
                    cell.setForeground(Color.GRAY);
                    return cell;
                }
                return super.getListCellRendererComponent((JList<?>)jList, o, i, b, b1);
            }
        });
        scrollPanel.setViewportView((Component)this.elementList);
        this.add((Component)scrollPanel, "Center");
        this.add((Component)toolbar, "South");
        this.elementList.getSelectionModel().addListSelectionListener(new SelectionActionEnabler(new javax.swing.Action[]{this.am.get("remove"), this.am.get("rename"), this.am.get("up"), this.am.get("down")}){

            @Override
            public boolean isSelectedValueValid(javax.swing.Action action) {
                boolean result = true;
                try {
                    int selectedIndex = SelectionElementsView.this.elementList.getSelectedIndex();
                    if (selectedIndex == -1) {
                        result = false;
                    } else if (action.equals(SelectionElementsView.this.am.get("up"))) {
                        if (selectedIndex == 0) {
                            result = false;
                        }
                    } else if (action.equals(SelectionElementsView.this.am.get("down")) && selectedIndex == SelectionElementsView.this.elementList.getModel().getSize() - 1) {
                        result = false;
                    }
                }
                catch (IndexOutOfBoundsException e) {
                    result = false;
                }
                return result;
            }
        });
        this.elementList.setSelectionMode(0);
    }

    @Action
    public Task add() {
        final NameDialog dialog = (NameDialog)this.module.objectBuilderFactory().newObject(NameDialog.class);
        this.dialogs.showOkCancelHelpDialog(this, dialog, i18n.text(AdministrationResources.name_label, new Object[0]));
        if (!Strings.empty((String)dialog.name())) {
            if (dialog.name().contains("[") || dialog.name().contains("]")) {
                this.dialogs.showOkDialog(this, new JLabel(i18n.text(AdministrationResources.no_such_character, new Object[0])), i18n.text(AdministrationResources.illegal_name, new Object[0]));
                return null;
            }
            return new CommandTask(){

                @Override
                public void command() throws Exception {
                    SelectionElementsView.this.model.addElement(dialog.name());
                }
            };
        }
        return null;
    }

    @Action
    public Task remove() {
        final int index = this.elementList.getSelectedIndex();
        ConfirmationDialog dialog = (ConfirmationDialog)this.module.objectBuilderFactory().newObject(ConfirmationDialog.class);
        dialog.setRemovalMessage(this.elementList.getStringAt(index));
        this.dialogs.showOkCancelHelpDialog(this, dialog, i18n.text(StreamflowResources.confirmation, new Object[0]));
        if (index != -1 && dialog.isConfirmed()) {
            this.elementList.clearSelection();
            return new CommandTask(){

                @Override
                public void command() throws Exception {
                    SelectionElementsView.this.model.removeElement(index);
                }
            };
        }
        return null;
    }

    @Action
    public Task up() {
        final int index = this.elementList.getSelectedIndex();
        if (index > 0 && index < this.elementList.getModel().getSize()) {
            this.elementList.setSelectedIndex(index - 1);
            return new CommandTask(){

                @Override
                public void command() throws Exception {
                    SelectionElementsView.this.model.moveElement("up", index);
                }
            };
        }
        return null;
    }

    @Action
    public Task down() {
        final int index = this.elementList.getSelectedIndex();
        if (index >= 0 && index < this.elementList.getModel().getSize() - 1) {
            this.elementList.setSelectedIndex(index + 1);
            return new CommandTask(){

                @Override
                public void command() throws Exception {
                    SelectionElementsView.this.model.moveElement("down", index);
                }
            };
        }
        return null;
    }

    @Action
    public Task rename() {
        final NameDialog dialog = (NameDialog)this.module.objectBuilderFactory().newObject(NameDialog.class);
        this.dialogs.showOkCancelHelpDialog(this, dialog, i18n.text(AdministrationResources.rename, new Object[0]));
        if (!Strings.empty((String)dialog.name())) {
            return new CommandTask(){

                @Override
                public void command() throws Exception {
                    SelectionElementsView.this.model.changeElementName(dialog.name(), SelectionElementsView.this.elementList.getSelectedIndex());
                }
            };
        }
        return null;
    }

    @Action
    public Task importvalues() {
        final JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(2);
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.addChoosableFileFilter(new FileNameExtensionFilter(i18n.text(AdministrationResources.import_files, new Object[0]), true, "xls", "csv", "txt"));
        fileChooser.setDialogTitle(i18n.text(AdministrationResources.import_values, new Object[0]));
        int returnVal = fileChooser.showOpenDialog(this);
        if (returnVal != 0) {
            return null;
        }
        return new CommandTask(){

            @Override
            public void command() throws Exception {
                SelectionElementsView.this.model.importValues(fileChooser.getSelectedFile().getAbsoluteFile());
            }
        };
    }

    @Action
    public Task removeall() {
        ConfirmationDialog dialog = (ConfirmationDialog)this.module.objectBuilderFactory().newObject(ConfirmationDialog.class);
        dialog.setRemovalMessage(i18n.text(StreamflowResources.all, new Object[0]));
        this.dialogs.showOkCancelHelpDialog(this, dialog, i18n.text(StreamflowResources.confirmation, new Object[0]));
        if (dialog.isConfirmed()) {
            return new CommandTask(){

                @Override
                public void command() throws Exception {
                    SelectionElementsView.this.model.removeAll();
                }
            };
        }
        return null;
    }

    public void notifyTransactions(Iterable<TransactionDomainEvents> transactions) {
        this.model.refresh();
    }
}

