/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.administration.forms.definition;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import java.io.File;
import java.util.List;
import org.qi4j.api.injection.scope.Uses;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.representation.FileRepresentation;
import org.restlet.resource.ResourceException;
import se.streamsource.dci.restlet.client.CommandQueryClient;
import se.streamsource.streamflow.api.administration.form.FieldDefinitionAdminValue;
import se.streamsource.streamflow.api.administration.form.FieldValue;
import se.streamsource.streamflow.api.administration.form.SelectionFieldValue;
import se.streamsource.streamflow.client.OperationException;
import se.streamsource.streamflow.client.ResourceModel;
import se.streamsource.streamflow.client.ui.administration.AdministrationResources;
import se.streamsource.streamflow.client.util.EventListSynch;
import se.streamsource.streamflow.client.util.Refreshable;

public class SelectionElementsModel
extends ResourceModel<FieldDefinitionAdminValue>
implements Refreshable {
    @Uses
    CommandQueryClient client;
    private EventList<String> elements = new BasicEventList();

    public EventList<String> getEventList() {
        return this.elements;
    }

    @Override
    public void refresh() {
        try {
            super.refresh();
            FieldValue field = (FieldValue)((FieldDefinitionAdminValue)this.getIndex()).fieldValue().get();
            if (field instanceof SelectionFieldValue) {
                SelectionFieldValue selectionField = (SelectionFieldValue)field;
                List elts = (List)selectionField.values().get();
                EventListSynch.synchronize(elts, this.elements);
            }
        }
        catch (ResourceException e) {
            throw new OperationException(AdministrationResources.could_not_get_field, (Throwable)e);
        }
    }

    public void addElement(String name) {
        Form form = new Form();
        form.set("selection", name);
        this.client.postCommand("addselectionelement", (Object)form.getWebRepresentation());
    }

    public void removeElement(int index) {
        Form form = new Form();
        form.set("index", Integer.toString(index));
        this.client.postCommand("removeselectionelement", (Object)form.getWebRepresentation());
    }

    public void moveElement(String direction, int index) {
        Form form = new Form();
        form.set("name", direction);
        form.set("index", Integer.toString(index));
        this.client.postCommand("moveselectionelement", (Object)form.getWebRepresentation());
    }

    public void changeElementName(String newName, int index) {
        Form form = new Form();
        form.set("name", newName);
        form.set("index", Integer.toString(index));
        this.client.postCommand("changeselectionelementname", (Object)form.getWebRepresentation());
    }

    public void importValues(File file) {
        MediaType type = file.getName().endsWith(".xls") ? MediaType.APPLICATION_EXCEL : MediaType.TEXT_CSV;
        FileRepresentation representation = new FileRepresentation(file, type);
        this.client.postCommand("importvalues", (Object)representation);
    }

    public void removeAll() {
        this.client.postCommand("removeallselectionelements");
    }
}

