/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.administration.forms.definition;

import ca.odell.glazedlists.swing.EventListModel;
import java.awt.Component;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.Task;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.specification.Specification;
import org.qi4j.api.structure.Module;
import org.qi4j.api.util.Iterables;
import org.qi4j.api.value.ValueBuilder;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.streamflow.api.administration.form.RequiredSignatureValue;
import se.streamsource.streamflow.client.StreamflowResources;
import se.streamsource.streamflow.client.ui.administration.AdministrationResources;
import se.streamsource.streamflow.client.ui.administration.forms.definition.FormSignatureView;
import se.streamsource.streamflow.client.ui.administration.forms.definition.FormSignaturesModel;
import se.streamsource.streamflow.client.util.CommandTask;
import se.streamsource.streamflow.client.util.ListDetailView;
import se.streamsource.streamflow.client.util.RefreshWhenShowing;
import se.streamsource.streamflow.client.util.dialog.ConfirmationDialog;
import se.streamsource.streamflow.client.util.dialog.DialogService;
import se.streamsource.streamflow.client.util.dialog.NameDialog;
import se.streamsource.streamflow.client.util.i18n;
import se.streamsource.streamflow.infrastructure.event.domain.DomainEvent;
import se.streamsource.streamflow.infrastructure.event.domain.TransactionDomainEvents;
import se.streamsource.streamflow.infrastructure.event.domain.source.helper.Events;
import se.streamsource.streamflow.util.Strings;

public class FormSignaturesView
extends ListDetailView {
    @Service
    DialogService dialogs;
    @Structure
    Module module;
    private FormSignaturesModel model;

    public FormSignaturesView(@Service ApplicationContext context, final @Uses FormSignaturesModel model) {
        this.model = model;
        ApplicationActionMap am = context.getActionMap((Object)this);
        this.initMaster((EventListModel<LinkValue>)new EventListModel(model.getList()), am.get("add"), new javax.swing.Action[]{am.get("remove")}, new ListDetailView.DetailFactory(){

            @Override
            public Component createDetail(LinkValue detailLink) {
                return (Component)FormSignaturesView.this.module.objectBuilderFactory().newObjectBuilder(FormSignatureView.class).use(new Object[]{model.newResourceModel(detailLink)}).newInstance();
            }
        });
        new RefreshWhenShowing(this, model);
    }

    @Action
    public Task add() {
        NameDialog dialog = (NameDialog)this.module.objectBuilderFactory().newObject(NameDialog.class);
        this.dialogs.showOkCancelHelpDialog(this, dialog, i18n.text(AdministrationResources.add_signature_title, new Object[0]));
        if (!Strings.empty((String)dialog.name())) {
            this.list.clearSelection();
            final ValueBuilder builder = this.module.valueBuilderFactory().newValueBuilder(RequiredSignatureValue.class);
            ((RequiredSignatureValue)builder.prototype()).name().set((Object)dialog.name());
            return new CommandTask(){

                @Override
                public void command() throws Exception {
                    FormSignaturesView.this.model.create((RequiredSignatureValue)builder.newInstance());
                }
            };
        }
        return null;
    }

    @Action
    public Task remove() {
        final LinkValue selected = this.getSelectedValue();
        if (selected != null) {
            ConfirmationDialog dialog = (ConfirmationDialog)this.module.objectBuilderFactory().newObject(ConfirmationDialog.class);
            dialog.setRemovalMessage((String)selected.text().get());
            this.dialogs.showOkCancelHelpDialog(this, dialog, i18n.text(StreamflowResources.confirmation, new Object[0]));
            if (dialog.isConfirmed()) {
                this.list.clearSelection();
                return new CommandTask(){

                    @Override
                    public void command() throws Exception {
                        FormSignaturesView.this.model.remove(selected);
                    }
                };
            }
        }
        return null;
    }

    @Override
    public void notifyTransactions(Iterable<TransactionDomainEvents> transactions) {
        this.model.notifyTransactions(transactions);
        DomainEvent event = (DomainEvent)Iterables.first((Iterable)Iterables.filter((Specification)Events.withNames((String[])new String[]{"createdRequiredSignature"}), (Iterable)Events.events(transactions)));
        if (event != null) {
            this.list.setSelectedIndex(this.list.getModel().getSize() - 1);
        }
        super.notifyTransactions(transactions);
    }
}

