/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.administration.forms.definition;

import ca.odell.glazedlists.swing.EventListModel;
import com.jgoodies.forms.factories.Borders;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationAction;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.Task;
import org.jdesktop.swingx.util.WindowUtils;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.specification.Specification;
import org.qi4j.api.structure.Module;
import org.qi4j.api.util.Iterables;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.streamflow.client.StreamflowResources;
import se.streamsource.streamflow.client.ui.administration.AdministrationResources;
import se.streamsource.streamflow.client.ui.administration.forms.definition.FieldCreationDialog;
import se.streamsource.streamflow.client.ui.administration.forms.definition.FieldCreationModel;
import se.streamsource.streamflow.client.ui.administration.forms.definition.FieldEditView;
import se.streamsource.streamflow.client.ui.administration.forms.definition.FormPagesModel;
import se.streamsource.streamflow.client.ui.administration.forms.definition.PageEditView;
import se.streamsource.streamflow.client.util.CommandTask;
import se.streamsource.streamflow.client.util.FormElementItemListCellRenderer;
import se.streamsource.streamflow.client.util.LinkListCellRenderer;
import se.streamsource.streamflow.client.util.RefreshWhenShowing;
import se.streamsource.streamflow.client.util.SelectionActionEnabler;
import se.streamsource.streamflow.client.util.StreamflowButton;
import se.streamsource.streamflow.client.util.dialog.ConfirmationDialog;
import se.streamsource.streamflow.client.util.dialog.DialogService;
import se.streamsource.streamflow.client.util.dialog.NameDialog;
import se.streamsource.streamflow.client.util.i18n;
import se.streamsource.streamflow.infrastructure.event.domain.DomainEvent;
import se.streamsource.streamflow.infrastructure.event.domain.TransactionDomainEvents;
import se.streamsource.streamflow.infrastructure.event.domain.source.TransactionListener;
import se.streamsource.streamflow.infrastructure.event.domain.source.helper.EventParameters;
import se.streamsource.streamflow.infrastructure.event.domain.source.helper.Events;
import se.streamsource.streamflow.util.Strings;

public class FormElementsView
extends JSplitPane
implements TransactionListener {
    @Service
    private DialogService dialogs;
    @Structure
    Module module;
    private JList list;
    private FormPagesModel model;
    private ActionMap am;

    public FormElementsView(@Service ApplicationContext context, final @Uses FormPagesModel model) {
        this.model = model;
        this.am = context.getActionMap((Object)this);
        this.setBorder(Borders.createEmptyBorder((String)"2dlu, 2dlu, 2dlu, 2dlu"));
        this.setRightComponent(new JPanel());
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setDividerLocation(350);
        this.setOneTouchExpandable(true);
        this.initMaster((EventListModel<LinkValue>)new EventListModel(model.getUnsortedList()), new DetailFactory(){

            @Override
            public Component createDetail(LinkValue detailLink) {
                if (detailLink == null) {
                    return new JPanel();
                }
                LinkValue link = FormElementsView.this.getSelectedValue();
                if (((String)link.rel().get()).equals("page")) {
                    return (Component)FormElementsView.this.module.objectBuilderFactory().newObjectBuilder(PageEditView.class).use(new Object[]{model.newResourceModel(link)}).newInstance();
                }
                return (Component)FormElementsView.this.module.objectBuilderFactory().newObjectBuilder(FieldEditView.class).use(new Object[]{model.newResourceModel(link)}).newInstance();
            }
        }, this.am.get("addPage"), this.am.get("addField"), this.am.get("remove"), this.am.get("up"), this.am.get("down"));
        this.list.setCellRenderer(new FormElementItemListCellRenderer());
        this.list.getSelectionModel().addListSelectionListener(new SelectionActionEnabler(this.am.get("addField"), this.am.get("remove")));
        this.list.getSelectionModel().addListSelectionListener(new SelectionActionEnabler(new javax.swing.Action[]{this.am.get("up"), this.am.get("down")}){

            @Override
            public boolean isSelectedValueValid(javax.swing.Action action) {
                boolean result = true;
                try {
                    int selectedIndex = FormElementsView.this.list.getSelectedIndex();
                    LinkValue link = (LinkValue)FormElementsView.this.list.getSelectedValue();
                    if (action.equals(FormElementsView.this.am.get("up"))) {
                        LinkValue previous;
                        if (((String)link.rel().get()).equals("page")) {
                            if (selectedIndex == 0) {
                                result = false;
                            }
                        } else if (((String)link.rel().get()).equals("field") && ((String)(previous = (LinkValue)FormElementsView.this.list.getModel().getElementAt(selectedIndex - 1)).rel().get()).equals("page")) {
                            result = false;
                        }
                    } else if (action.equals(FormElementsView.this.am.get("down"))) {
                        if (((String)link.rel().get()).equals("page")) {
                            if (selectedIndex == this.lastPageIndex()) {
                                result = false;
                            }
                        } else if (selectedIndex == FormElementsView.this.list.getModel().getSize() - 1 || ((String)((LinkValue)FormElementsView.this.list.getModel().getElementAt(selectedIndex + 1)).rel().get()).equals("page")) {
                            result = false;
                        }
                    }
                }
                catch (IndexOutOfBoundsException e) {
                    result = false;
                }
                return result;
            }

            private int lastPageIndex() {
                int lastIndex = -1;
                ListModel listModel = FormElementsView.this.list.getModel();
                for (int i = 0; i < listModel.getSize(); ++i) {
                    LinkValue link = (LinkValue)listModel.getElementAt(i);
                    if (!((String)link.rel().get()).equals("page")) continue;
                    lastIndex = i;
                }
                return lastIndex;
            }
        });
        new RefreshWhenShowing(this, model);
    }

    @Action
    public Task addField() {
        final LinkValue page = this.findSelectedPage(this.getSelectedValue());
        FieldCreationModel fieldCreationModel = (FieldCreationModel)this.module.objectBuilderFactory().newObjectBuilder(FieldCreationModel.class).use(new Object[]{this.model.getClient().getSubClient((String)page.id().get())}).newInstance();
        final FieldCreationDialog dialog = (FieldCreationDialog)this.module.objectBuilderFactory().newObjectBuilder(FieldCreationDialog.class).use(new Object[]{fieldCreationModel}).newInstance();
        this.dialogs.showOkCancelHelpDialog(this, dialog, i18n.text(AdministrationResources.add_field_to_form, new Object[0]));
        if (!Strings.empty((String)dialog.name()) && dialog.getAddLink() != null) {
            this.list.clearSelection();
            return new CommandTask(){

                @Override
                public void command() throws Exception {
                    FormElementsView.this.model.addField(page, dialog.name(), dialog.getAddLink());
                }
            };
        }
        return null;
    }

    private LinkValue findSelectedPage(LinkValue selected) {
        if (((String)selected.rel().get()).equals("page")) {
            return selected;
        }
        int i1 = ((String)selected.href().get()).indexOf((String)selected.id().get());
        String id = ((String)selected.href().get()).substring(0, i1 - 1);
        for (LinkValue link : this.model.getList()) {
            if (!id.equals(link.id().get())) continue;
            return link;
        }
        return null;
    }

    @Action
    public Task addPage() {
        final NameDialog dialog = (NameDialog)this.module.objectBuilderFactory().newObject(NameDialog.class);
        this.dialogs.showOkCancelHelpDialog(this, dialog, i18n.text(AdministrationResources.add_page_title, new Object[0]));
        if (!Strings.empty((String)dialog.name())) {
            this.list.clearSelection();
            return new CommandTask(){

                @Override
                public void command() throws Exception {
                    FormElementsView.this.model.addPage(dialog.name());
                }
            };
        }
        return null;
    }

    @Action
    public Task remove() {
        final LinkValue selected = this.getSelectedValue();
        if (selected != null) {
            ConfirmationDialog dialog = (ConfirmationDialog)this.module.objectBuilderFactory().newObject(ConfirmationDialog.class);
            dialog.setRemovalMessage((String)selected.text().get());
            this.dialogs.showOkCancelHelpDialog(this, dialog, i18n.text(StreamflowResources.confirmation, new Object[0]));
            if (dialog.isConfirmed()) {
                return new CommandTask(){

                    @Override
                    public void command() throws Exception {
                        FormElementsView.this.model.remove(selected);
                    }
                };
            }
        }
        return null;
    }

    @Action
    public Task up() {
        final LinkValue selected = this.getSelectedValue();
        return new CommandTask(){

            @Override
            public void command() throws Exception {
                FormElementsView.this.model.move(selected, "up");
            }
        };
    }

    @Action
    public Task down() {
        final LinkValue selected = this.getSelectedValue();
        if (selected != null) {
            return new CommandTask(){

                @Override
                public void command() throws Exception {
                    FormElementsView.this.model.move(selected, "down");
                }
            };
        }
        return null;
    }

    public void notifyTransactions(Iterable<TransactionDomainEvents> transactions) {
        DomainEvent event;
        if (Events.matches((Specification)Events.withNames((String[])new String[]{"removedPage", "removedField"}), transactions)) {
            this.list.clearSelection();
        }
        if (Events.matches((Specification)Events.withNames((String[])new String[]{"changedDescription", "removedPage", "removedField", "movedField", "movedPage"}), transactions)) {
            this.model.refresh();
        }
        if ((event = (DomainEvent)Iterables.first((Iterable)Iterables.filter((Specification)Events.withNames((String[])new String[]{"createdField", "createdPage", "movedField", "movedPage"}), (Iterable)Events.events(transactions)))) != null) {
            String id = EventParameters.getParameter((DomainEvent)event, (int)1);
            for (LinkValue link : this.model.getUnsortedList()) {
                Component c;
                if (!((String)link.href().get()).endsWith(id + "/")) continue;
                this.list.setSelectedValue(link, true);
                if (!((String)event.name().get()).equals("createdField") || (c = (Component)Iterables.first((Iterable)Iterables.filter((Specification)new Specification<Component>(){

                    public boolean satisfiedBy(Component c) {
                        return c instanceof StreamflowButton && ((ApplicationAction)((StreamflowButton)c).getAction()).getName().equals("addField");
                    }
                }, (Iterable)WindowUtils.getAllComponents((Container)this)))) == null) break;
                c.requestFocusInWindow();
                break;
            }
        }
    }

    protected void initMaster(EventListModel<LinkValue> listModel, final DetailFactory factory, javax.swing.Action ... actions) {
        this.list = new JList<LinkValue>((ListModel<LinkValue>)listModel);
        this.list.setCellRenderer(new LinkListCellRenderer());
        JScrollPane scrollPane = new JScrollPane(this.list);
        JPanel master = new JPanel(new BorderLayout());
        master.add((Component)scrollPane, "Center");
        JPanel toolbar = new JPanel();
        for (javax.swing.Action action : actions) {
            toolbar.add(new StreamflowButton(action));
        }
        master.add((Component)toolbar, "South");
        this.setLeftComponent(master);
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    FormElementsView.this.setRightComponent(factory.createDetail(FormElementsView.this.getSelectedValue()));
                }
            }
        });
    }

    private LinkValue getSelectedValue() {
        return (LinkValue)this.list.getSelectedValue();
    }

    public static interface DetailFactory {
        public Component createDetail(LinkValue var1);
    }
}

