/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.administration;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.TransactionList;
import ca.odell.glazedlists.TreeList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.specification.Specification;
import org.qi4j.api.structure.Module;
import org.qi4j.api.util.Iterables;
import org.qi4j.api.value.ValueBuilder;
import org.restlet.data.Form;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import se.streamsource.dci.value.StringValue;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.dci.value.link.LinksValue;
import se.streamsource.streamflow.client.OperationException;
import se.streamsource.streamflow.client.ResourceModel;
import se.streamsource.streamflow.client.ui.administration.AdministrationResources;
import se.streamsource.streamflow.client.ui.administration.OrganizationModel;
import se.streamsource.streamflow.client.ui.administration.OrganizationalUnitModel;
import se.streamsource.streamflow.client.util.EventListSynch;
import se.streamsource.streamflow.client.util.Refreshable;
import se.streamsource.streamflow.infrastructure.event.domain.TransactionDomainEvents;
import se.streamsource.streamflow.infrastructure.event.domain.source.TransactionListener;

public class AdministrationModel
extends ResourceModel<LinksValue>
implements Refreshable,
TransactionListener {
    @Structure
    Module module;
    private EventList<LinkValue> links = new TransactionList((EventList)new BasicEventList());
    private TreeList<LinkValue> linkTree = new TreeList(this.links, (TreeList.Format)new LinkValueFormat(), TreeList.NODES_START_EXPANDED);

    public AdministrationModel() {
        this.relationModelMapping("organization", OrganizationModel.class);
        this.relationModelMapping("organizationalunit", OrganizationalUnitModel.class);
    }

    @Override
    public void refresh() {
        super.refresh();
        LinksValue administration = (LinksValue)this.getIndex();
        EventListSynch.synchronize((Collection)administration.links().get(), this.links);
        this.linkTree = new TreeList(this.links, (TreeList.Format)new LinkValueFormat(), TreeList.NODES_START_EXPANDED);
    }

    public TreeList<LinkValue> getLinkTree() {
        return this.linkTree;
    }

    public void changeDescription(Object node, String newDescription) {
        TreeList.Node treeNode = (TreeList.Node)node;
        LinkValue link = (LinkValue)treeNode.getElement();
        ValueBuilder builder = this.module.valueBuilderFactory().newValueBuilder(StringValue.class);
        ((StringValue)builder.prototype()).string().set((Object)newDescription);
        this.client.getClient(link).postCommand("changedescription", builder.newInstance());
    }

    public void createOrganizationalUnit(LinkValue node, String name) {
        Form form = new Form();
        form.set("name", name);
        this.client.getClient(node).postCommand("create", (Object)form);
    }

    public void removeOrganizationalUnit(Object node) {
        block2: {
            TreeList.Node treeNode = (TreeList.Node)node;
            LinkValue link = (LinkValue)treeNode.getElement();
            try {
                this.client.getClient(link).delete();
            }
            catch (ResourceException e) {
                if (!Status.SERVER_ERROR_INTERNAL.equals((Object)e.getStatus())) break block2;
                throw new OperationException(AdministrationResources.could_not_remove_organisation_with_open_projects, (Throwable)e);
            }
        }
    }

    public EventList<LinkValue> possibleMoveTo(Object node) {
        TreeList.Node treeNode = (TreeList.Node)node;
        LinkValue link = (LinkValue)treeNode.getElement();
        BasicEventList links = new BasicEventList();
        EventListSynch.synchronize((Collection)((LinksValue)this.client.getClient(link).query("possiblemoveto", LinksValue.class)).links().get(), links);
        return links;
    }

    public void move(Object node, LinkValue moveTo) {
        TreeList.Node treeNode = (TreeList.Node)node;
        LinkValue link = (LinkValue)treeNode.getElement();
        this.client.getClient(link).postLink(moveTo);
    }

    public EventList<LinkValue> possibleMergeWith(Object node) {
        TreeList.Node treeNode = (TreeList.Node)node;
        LinkValue link = (LinkValue)treeNode.getElement();
        BasicEventList links = new BasicEventList();
        EventListSynch.synchronize((Collection)((LinksValue)this.client.getClient(link).query("possiblemergewith", LinksValue.class)).links().get(), links);
        return links;
    }

    public void merge(Object node, LinkValue mergeWith) {
        TreeList.Node treeNode = (TreeList.Node)node;
        LinkValue link = (LinkValue)treeNode.getElement();
        this.client.getClient(link).postLink(link);
    }

    public void notifyTransactions(Iterable<TransactionDomainEvents> transactions) {
        this.refresh();
    }

    public boolean isParticipantInGroup(String groupId, String participantId) {
        Form form = new Form();
        form.add("groupid", groupId);
        form.add("participantid", participantId);
        return new Boolean((String)this.client.query("isparticipantingroup", String.class, (Object)form));
    }

    private class LinkValueFormat
    implements TreeList.Format<LinkValue> {
        private LinkValueFormat() {
        }

        public void getPath(List<LinkValue> linkValues, LinkValue linkValue) {
            String classes = (String)linkValue.classes().get();
            if (classes != null) {
                for (final LinkValue value : AdministrationModel.this.links) {
                    if (!Iterables.matchesAny((Specification)new Specification<String>(){

                        public boolean satisfiedBy(String item) {
                            return item.equals(value.id().get());
                        }
                    }, Arrays.asList(classes.split(" ")))) continue;
                    this.getPath(linkValues, value);
                    break;
                }
            }
            linkValues.add(linkValue);
        }

        public boolean allowsChildren(LinkValue linkValue) {
            for (final LinkValue link : AdministrationModel.this.links) {
                String classes = (String)link.classes().get();
                if (classes == null || !Iterables.matchesAny((Specification)new Specification<String>(){

                    public boolean satisfiedBy(String item) {
                        return item.equals(link.id().get());
                    }
                }, Arrays.asList(classes.split(" ")))) continue;
                return true;
            }
            return false;
        }

        public Comparator<? extends LinkValue> getComparator(int i) {
            return null;
        }
    }
}

