/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.account;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.ActionMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.border.EmptyBorder;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.Task;
import org.jdesktop.application.TaskEvent;
import org.jdesktop.application.TaskListener;
import org.jdesktop.swingx.util.WindowUtils;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.structure.Module;
import org.qi4j.api.unitofwork.UnitOfWorkCompletionException;
import org.qi4j.api.value.ValueBuilder;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import se.streamsource.streamflow.api.ErrorResources;
import se.streamsource.streamflow.api.administration.ChangePasswordDTO;
import se.streamsource.streamflow.client.domain.individual.AccountSettingsValue;
import se.streamsource.streamflow.client.ui.account.AccountModel;
import se.streamsource.streamflow.client.ui.account.AccountResources;
import se.streamsource.streamflow.client.ui.account.ChangePasswordDialog;
import se.streamsource.streamflow.client.ui.account.FormEditor;
import se.streamsource.streamflow.client.ui.account.TestConnectionTask;
import se.streamsource.streamflow.client.ui.administration.AdministrationResources;
import se.streamsource.streamflow.client.ui.workspace.WorkspaceResources;
import se.streamsource.streamflow.client.util.BindingFormBuilder;
import se.streamsource.streamflow.client.util.StateBinder;
import se.streamsource.streamflow.client.util.StreamflowButton;
import se.streamsource.streamflow.client.util.dialog.DialogService;
import se.streamsource.streamflow.client.util.i18n;

public class AccountView
extends JScrollPane {
    @Structure
    private Module module;
    @Uses
    private AccountModel model;
    @Service
    private DialogService dialogs;
    private ValueBuilder<AccountSettingsValue> accountSettingsBuilder;
    private StateBinder accountBinder;
    private StateBinder connectedBinder;
    private ApplicationContext context;
    public FormEditor accountEditor;
    public JPanel accountForm;
    public JPanel contactForm;

    public AccountView(@Service ApplicationContext context, @Structure Module module) {
        this.context = context;
        ApplicationActionMap am = context.getActionMap((Object)this);
        this.setActionMap((ActionMap)am);
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(new EmptyBorder(new Insets(10, 10, 10, 10)));
        this.accountForm = new JPanel();
        panel.add((Component)this.accountForm, "North");
        FormLayout accountLayout = new FormLayout("75dlu, 5dlu, 120dlu:grow", "pref, pref, pref, pref, pref");
        DefaultFormBuilder accountBuilder = new DefaultFormBuilder(accountLayout, this.accountForm);
        this.accountBinder = (StateBinder)module.objectBuilderFactory().newObject(StateBinder.class);
        this.accountBinder.setResourceMap(context.getResourceMap(this.getClass()));
        this.connectedBinder = (StateBinder)module.objectBuilderFactory().newObject(StateBinder.class);
        AccountSettingsValue accountTemplate = this.accountBinder.bindingTemplate(AccountSettingsValue.class);
        accountBuilder.appendSeparator(i18n.text(AccountResources.account_separator, new Object[0]));
        accountBuilder.nextLine();
        accountBuilder.add((Component)new JLabel(i18n.text(AccountResources.account_name_label, new Object[0])));
        accountBuilder.nextColumn(2);
        accountBuilder.add(this.accountBinder.bind(BindingFormBuilder.Fields.TEXTFIELD.newField(), accountTemplate.name()));
        accountBuilder.nextLine();
        accountBuilder.add((Component)new JLabel(i18n.text(AccountResources.server_label, new Object[0])));
        accountBuilder.nextColumn(2);
        accountBuilder.add(this.accountBinder.bind(BindingFormBuilder.Fields.TEXTFIELD.newField(), accountTemplate.server()));
        accountBuilder.nextLine();
        accountBuilder.add((Component)new JLabel(i18n.text(AccountResources.username_label, new Object[0])));
        accountBuilder.nextColumn(2);
        accountBuilder.add(this.accountBinder.bind(BindingFormBuilder.Fields.TEXTFIELD.newField(), accountTemplate.userName()));
        accountBuilder.nextLine();
        accountBuilder.add((Component)new JLabel(i18n.text(AccountResources.password_label, new Object[0])));
        accountBuilder.nextColumn(2);
        accountBuilder.add(this.accountBinder.bind(BindingFormBuilder.Fields.PASSWORD.newField(), accountTemplate.password()));
        accountBuilder.nextLine();
        this.accountEditor = new FormEditor(this.accountForm);
        this.contactForm = new JPanel();
        panel.add((Component)this.contactForm, "Center");
        FormLayout contactLayout = new FormLayout("75dlu, 5dlu,80dlu, 80dlu", "pref, pref, pref, pref, pref, pref, pref, pref, pref, pref, pref, pref");
        DefaultFormBuilder contactBuilder = new DefaultFormBuilder(contactLayout, this.contactForm);
        JToggleButton editBtn = new JToggleButton(am.get("edit"));
        editBtn.setHorizontalAlignment(2);
        contactBuilder.add((Component)editBtn, new CellConstraints(4, 5, 1, 1, CellConstraints.FILL, CellConstraints.BOTTOM, new Insets(0, 0, 0, 0)));
        StreamflowButton testBtn = new StreamflowButton(am.get("test"));
        testBtn.setHorizontalAlignment(2);
        contactBuilder.add((Component)testBtn, new CellConstraints(4, 6, 1, 1, CellConstraints.FILL, CellConstraints.BOTTOM, new Insets(0, 0, 0, 0)));
        StreamflowButton changepasswordBtn = new StreamflowButton(am.get("changepassword"));
        changepasswordBtn.setHorizontalAlignment(2);
        contactBuilder.add((Component)changepasswordBtn, new CellConstraints(4, 7, 1, 1, CellConstraints.FILL, CellConstraints.BOTTOM, new Insets(0, 0, 0, 0)));
        this.setViewportView(panel);
    }

    @Action(block=Task.BlockingScope.APPLICATION)
    public Task test() {
        Task task = (Task)this.module.objectBuilderFactory().newObjectBuilder(TestConnectionTask.class).use(new Object[]{this.model}).newInstance();
        task.addTaskListener((TaskListener)new TaskListener.Adapter<String, Void>(){

            public void succeeded(TaskEvent<String> stringTaskEvent) {
                String result = (String)stringTaskEvent.getValue();
                AccountView.this.dialogs.showMessageDialog(AccountView.this, result, "Server Version:");
            }

            public void failed(TaskEvent<Throwable> throwableTaskEvent) {
                try {
                    throw (Throwable)throwableTaskEvent.getValue();
                }
                catch (ResourceException e) {
                    if (e.getStatus().equals((Object)Status.CLIENT_ERROR_UNAUTHORIZED)) {
                        AccountView.this.dialogs.showMessageDialog(AccountView.this, i18n.text(AccountResources.wrong_user_password, new Object[0]), "Info");
                    } else {
                        AccountView.this.dialogs.showMessageDialog(AccountView.this, i18n.text(AccountResources.connection_not_ok, new Object[0]) + " " + e.getStatus().toString(), "Info");
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        });
        return task;
    }

    @Action
    public void changepassword() throws Exception {
        if (this.model.ldapon()) {
            this.dialogs.showMessageDialog(this, "   " + i18n.text(WorkspaceResources.change_password_prohibited, new Object[0]) + "   ", i18n.text(WorkspaceResources.change_password_title, new Object[0]));
            return;
        }
        ChangePasswordDialog changePasswordDialog = (ChangePasswordDialog)this.module.objectBuilderFactory().newObject(ChangePasswordDialog.class);
        this.dialogs.showOkCancelHelpDialog(this, changePasswordDialog, i18n.text(WorkspaceResources.change_password_title, new Object[0]));
        ChangePasswordDTO DTO = changePasswordDialog.command();
        if (DTO != null) {
            if (!((String)DTO.oldPassword().get()).equals(this.model.settings().password().get())) {
                this.dialogs.showOkDialog(this, new JLabel(i18n.text(AdministrationResources.old_password_incorrect, new Object[0])));
            } else {
                try {
                    this.model.changePassword((String)DTO.oldPassword().get(), (String)DTO.newPassword().get());
                }
                catch (Exception cve) {
                    this.dialogs.showOkCancelHelpDialog(WindowUtils.findWindow((Component)this), new JLabel(i18n.text((Enum)ErrorResources.password_violation, new Object[0])));
                    return;
                }
            }
        }
    }

    @Action
    public void edit() throws UnitOfWorkCompletionException {
        if (!this.accountEditor.isEditing()) {
            this.accountEditor.edit();
        } else {
            this.accountEditor.view();
            this.model.updateSettings((AccountSettingsValue)this.accountSettingsBuilder.newInstance());
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.accountSettingsBuilder = this.model.settings().buildWith();
        this.accountBinder.updateWith(this.accountSettingsBuilder.prototype());
        this.connectedBinder.update();
    }

    public void setModel(AccountModel model) {
        this.model = model;
    }
}

