/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.account;

import java.io.IOException;
import java.util.Observable;
import org.json.JSONException;
import org.json.JSONObject;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.structure.Module;
import org.qi4j.api.unitofwork.UnitOfWork;
import org.qi4j.api.unitofwork.UnitOfWorkCompletionException;
import org.restlet.Uniform;
import org.restlet.resource.ResourceException;
import se.streamsource.dci.restlet.client.CommandQueryClient;
import se.streamsource.streamflow.client.domain.individual.Account;
import se.streamsource.streamflow.client.domain.individual.AccountSettingsValue;
import se.streamsource.streamflow.client.domain.individual.IndividualRepository;
import se.streamsource.streamflow.client.ui.account.ProfileModel;
import se.streamsource.streamflow.client.ui.administration.AdministrationModel;
import se.streamsource.streamflow.client.ui.overview.OverviewModel;
import se.streamsource.streamflow.client.ui.workspace.WorkspaceModel;

public class AccountModel
extends Observable {
    @Structure
    Module module;
    @Service
    IndividualRepository individualRepository;
    @Service
    Uniform client;
    @Uses
    Account account;
    private ProfileModel profileModel;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccountSettingsValue settings() {
        UnitOfWork uow = this.module.unitOfWorkFactory().newUnitOfWork();
        Account acc = (Account)uow.get((Object)this.account);
        try {
            AccountSettingsValue accountSettingsValue = acc.accountSettings();
            return accountSettingsValue;
        }
        finally {
            uow.discard();
        }
    }

    public void updateSettings(AccountSettingsValue value) throws UnitOfWorkCompletionException {
        UnitOfWork uow = this.module.unitOfWorkFactory().newUnitOfWork();
        ((Account)uow.get((Object)this.account)).updateSettings(value);
        uow.complete();
        this.setChanged();
        this.notifyObservers();
    }

    public String test() throws IOException, ResourceException {
        UnitOfWork uow = this.module.unitOfWorkFactory().newUnitOfWork();
        try {
            String string = ((Account)uow.get((Object)this.account)).version(this.client);
            return string;
        }
        finally {
            uow.discard();
        }
    }

    public ProfileModel getProfileModel() {
        if (this.profileModel == null) {
            this.profileModel = (ProfileModel)this.module.objectBuilderFactory().newObjectBuilder(ProfileModel.class).use(new Object[]{this.serverResource().getSubClient("account").getSubClient("profile")}).newInstance();
            this.profileModel.refresh();
        }
        return this.profileModel;
    }

    public OverviewModel newOverviewModel() {
        return (OverviewModel)this.module.objectBuilderFactory().newObjectBuilder(OverviewModel.class).use(new Object[]{this.serverResource().getSubClient("overview")}).newInstance();
    }

    public WorkspaceModel newWorkspaceModel() {
        return (WorkspaceModel)this.module.objectBuilderFactory().newObjectBuilder(WorkspaceModel.class).use(new Object[]{this.serverResource().getSubClient("workspace")}).newInstance();
    }

    public AdministrationModel newAdministrationModel() {
        return (AdministrationModel)this.module.objectBuilderFactory().newObjectBuilder(AdministrationModel.class).use(new Object[]{this.serverResource().getSubClient("administration")}).newInstance();
    }

    private CommandQueryClient serverResource() {
        UnitOfWork uow = this.module.unitOfWorkFactory().newUnitOfWork();
        try {
            CommandQueryClient commandQueryClient = ((Account)uow.get((Object)this.account)).server(this.client);
            return commandQueryClient;
        }
        finally {
            uow.discard();
        }
    }

    public void remove() throws UnitOfWorkCompletionException {
        UnitOfWork uow = this.module.unitOfWorkFactory().newUnitOfWork();
        Account acc = (Account)uow.get((Object)this.account);
        this.individualRepository.individual().removeAccount(acc);
        uow.complete();
    }

    public void changePassword(String oldPassword, String newPassword) throws Exception {
        UnitOfWork uow = this.module.unitOfWorkFactory().newUnitOfWork();
        try {
            Account account1 = (Account)uow.get((Object)this.account);
            account1.changePassword(this.client, oldPassword, newPassword);
            uow.complete();
        }
        catch (Exception ex) {
            uow.discard();
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ldapon() {
        UnitOfWork uow = this.module.unitOfWorkFactory().newUnitOfWork();
        try {
            boolean result = false;
            try {
                result = new JSONObject((String)((Account)uow.get((Object)this.account)).server(this.client).getSubClient("account").query("ldapon", String.class)).getBoolean("string");
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            boolean bl = result;
            return bl;
        }
        finally {
            uow.discard();
        }
    }
}

