/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui;

import ca.odell.glazedlists.EventList;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.HashSet;
import java.util.Set;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.swingx.util.WindowUtils;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Uses;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.dci.value.link.TitledLinkValue;
import se.streamsource.streamflow.client.ui.administration.AdministrationResources;
import se.streamsource.streamflow.client.ui.administration.UsersAndGroupsModel;
import se.streamsource.streamflow.client.util.GroupedFilteredList;
import se.streamsource.streamflow.client.util.i18n;

public class SelectUsersAndGroupsDialog
extends JPanel {
    private GroupedFilteredList groupList;
    private GroupedFilteredList userList;
    private Set<LinkValue> selectedEntities;

    public SelectUsersAndGroupsDialog(@Service ApplicationContext context, @Uses UsersAndGroupsModel model) {
        super(new GridLayout(1, 2));
        this.setActionMap((ActionMap)context.getActionMap((Object)this));
        this.getActionMap().put("close", this.getActionMap().get("cancel"));
        this.setName(i18n.text(AdministrationResources.search_users_or_groups, new Object[0]));
        this.selectedEntities = new HashSet<LinkValue>();
        EventList<TitledLinkValue> groups = model.getPossibleGroups();
        this.groupList = new GroupedFilteredList();
        this.groupList.setEventList(groups);
        this.groupList.setBorder(BorderFactory.createTitledBorder(i18n.text(AdministrationResources.group_title, new Object[0])));
        this.add(this.groupList);
        EventList<TitledLinkValue> users = model.getPossibleUsers();
        this.userList = new GroupedFilteredList();
        this.userList.setEventList(users);
        this.userList.setBorder(BorderFactory.createTitledBorder(i18n.text(AdministrationResources.user_title, new Object[0])));
        this.add(this.userList);
    }

    public Set<LinkValue> getSelectedEntities() {
        return this.selectedEntities;
    }

    @Action
    public void execute() {
        for (Object value : this.groupList.getList().getSelectedValues()) {
            this.selectedEntities.add((LinkValue)value);
        }
        for (Object value : this.userList.getList().getSelectedValues()) {
            this.selectedEntities.add((LinkValue)value);
        }
        WindowUtils.findWindow((Component)this).dispose();
    }

    @Action
    public void cancel() {
        WindowUtils.findWindow((Component)this).dispose();
    }
}

