/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.infrastructure.events;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.mixin.Mixins;
import org.qi4j.api.service.Activatable;
import org.qi4j.api.service.ServiceComposite;
import org.qi4j.api.structure.Module;
import org.restlet.Response;
import org.restlet.data.Method;
import org.restlet.representation.EmptyRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.ResourceException;
import se.streamsource.dci.restlet.client.ResponseHandler;
import se.streamsource.streamflow.infrastructure.event.domain.TransactionDomainEvents;
import se.streamsource.streamflow.infrastructure.event.domain.source.EventStream;
import se.streamsource.streamflow.infrastructure.event.domain.source.TransactionListener;

@Mixins(value={Mixin.class})
public interface ClientEventSourceService
extends EventStream,
ResponseHandler,
ServiceComposite {

    public static class Mixin
    implements EventStream,
    ResponseHandler,
    Activatable {
        @Structure
        Module module;
        private List<Reference<TransactionListener>> listeners = new ArrayList<Reference<TransactionListener>>();

        public void activate() throws Exception {
        }

        public void passivate() throws Exception {
        }

        public void registerListener(TransactionListener listener) {
            this.listeners.add(new WeakReference<TransactionListener>(listener));
        }

        public void unregisterListener(TransactionListener listener) {
            Iterator<Reference<TransactionListener>> referenceIterator = this.listeners.iterator();
            while (referenceIterator.hasNext()) {
                Reference<TransactionListener> eventSourceListenerReference = referenceIterator.next();
                TransactionListener lstnr = eventSourceListenerReference.get();
                if (lstnr != null && !lstnr.equals(listener)) continue;
                referenceIterator.remove();
                return;
            }
        }

        public void handleResponse(Response response) throws ResourceException {
            if (response.getStatus().isSuccess() && (response.getRequest().getMethod().equals((Object)Method.POST) || response.getRequest().getMethod().equals((Object)Method.DELETE) || response.getRequest().getMethod().equals((Object)Method.PUT))) {
                try {
                    Representation entity = response.getEntity();
                    if (entity != null && !(entity instanceof EmptyRepresentation)) {
                        String source = entity.getText();
                        TransactionDomainEvents transactionDomainEvents = (TransactionDomainEvents)this.module.valueBuilderFactory().newValueFromJSON(TransactionDomainEvents.class, source);
                        this.notifyTransactionListeners(transactionDomainEvents);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not process events", e);
                }
            }
        }

        private void notifyTransactionListeners(TransactionDomainEvents transactionDomain) {
            for (Reference<TransactionListener> eventSourceListenerReference : new ArrayList<Reference<TransactionListener>>(this.listeners)) {
                TransactionListener lstnr = eventSourceListenerReference.get();
                if (lstnr == null) continue;
                lstnr.notifyTransactions(Collections.singleton(transactionDomain));
            }
        }
    }
}

