/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.TransactionList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.specification.Specification;
import org.qi4j.api.structure.Module;
import org.qi4j.api.util.Iterables;
import se.streamsource.dci.restlet.client.CommandQueryClient;
import se.streamsource.dci.value.ResourceValue;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.dci.value.link.Links;
import se.streamsource.streamflow.client.util.EventListSynch;
import se.streamsource.streamflow.client.util.Refreshable;

public abstract class ResourceModel<INDEXTYPE>
extends Observable
implements Refreshable {
    @Structure
    protected Module module;
    @Uses
    protected CommandQueryClient client;
    protected ResourceValue resourceValue;
    private TransactionList<LinkValue> commands = new TransactionList((EventList)new BasicEventList());
    private TransactionList<LinkValue> queries = new TransactionList((EventList)new BasicEventList());
    private TransactionList<LinkValue> resources = new TransactionList((EventList)new BasicEventList());
    private Map<String, Class> relationModelMap = new HashMap<String, Class>();

    @Override
    public void refresh() {
        this.resourceValue = this.client.query();
        EventListSynch.synchronize((Collection)this.resourceValue.commands().get(), this.commands);
        EventListSynch.synchronize((Collection)this.resourceValue.queries().get(), this.queries);
        EventListSynch.synchronize((Collection)this.resourceValue.resources().get(), this.resources);
        this.setChanged();
        this.notifyObservers(this.resourceValue);
    }

    public ResourceValue getResourceValue() {
        return this.resourceValue;
    }

    public TransactionList<LinkValue> getCommands() {
        return this.commands;
    }

    public LinkValue command(String rel) {
        return (LinkValue)Iterables.first((Iterable)Iterables.filter((Specification)Links.withRel((String)rel), this.getCommands()));
    }

    public TransactionList<LinkValue> getQueries() {
        return this.queries;
    }

    public LinkValue query(String rel) {
        return (LinkValue)Iterables.first((Iterable)Iterables.filter((Specification)Links.withRel((String)rel), this.getQueries()));
    }

    public TransactionList<LinkValue> getResources() {
        return this.resources;
    }

    public INDEXTYPE getIndex() {
        return (INDEXTYPE)(this.resourceValue == null ? null : this.resourceValue.index().get());
    }

    public Object newResourceModel(LinkValue resource) throws IllegalArgumentException {
        Class modelClass = this.relationModelMap.get(resource.rel().get());
        if (modelClass == null) {
            throw new IllegalArgumentException("Unknown relation type:" + (String)resource.rel().get());
        }
        return this.module.objectBuilderFactory().newObjectBuilder(modelClass).use(new Object[]{this.client.getClient(resource)}).newInstance();
    }

    public boolean equals(Object obj) {
        return obj instanceof ResourceModel && this.client.getReference().equals((Object)((ResourceModel)obj).client.getReference());
    }

    public String toString() {
        return this.client.getReference().toString();
    }

    protected void relationModelMapping(String relation, Class modelClass) {
        this.relationModelMap.put(relation, modelClass);
    }

    public CommandQueryClient getClient() {
        return this.client;
    }
}

