/**
 *
 * Copyright
 * 2009-2015 Jayway Products AB
 * 2016-2017 Föreningen Sambruk
 *
 * Licensed under AGPL, Version 3.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.gnu.org/licenses/agpl.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package se.streamsource.streamflow.client.ui.workspace.context;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import org.jdesktop.application.Application;
import org.jdesktop.application.Task;
import org.qi4j.api.injection.scope.Uses;
import org.restlet.data.Reference;
import se.streamsource.dci.restlet.client.CommandQueryClient;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.dci.value.link.LinksValue;
import se.streamsource.streamflow.client.ui.ContextItem;
import se.streamsource.streamflow.client.util.EventListSynch;
import se.streamsource.streamflow.client.util.Refreshable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import static se.streamsource.streamflow.client.ui.workspace.WorkspaceResources.*;
import static se.streamsource.streamflow.client.util.i18n.text;

/**
 * JAVADOC
 */
public class WorkspaceContextModel
        implements Refreshable
{
   EventList<ContextItem> items = new BasicEventList<ContextItem>();

   @Uses
   CommandQueryClient client;

   LinksValue caseCounts;

   public EventList<ContextItem> getItems()
   {
      return items;
   }

   public void refresh()
   {
      // Refresh case counts in the background
      new Task<LinksValue, Object>(Application.getInstance())
      {
         @Override
         protected LinksValue doInBackground() throws Exception
         {
            return client.query("casecounts", LinksValue.class);
         }

         @Override
         protected void succeeded(LinksValue linksValue)
         {
            caseCounts = linksValue;
            applyCounts();
         }
      }.execute();

      List<ContextItem> list = new ArrayList<ContextItem>();

      LinksValue projects = client.query("index", LinksValue.class);
      for (LinkValue contextLink : projects.links().get())
      {
         if (contextLink.rel().get().equals("drafts"))
         {
            list.add(new ContextItem("", text(drafts_node), "draft", -1, client.getClient(contextLink)));
         } else if (contextLink.rel().get().equals("search"))
         {
            list.add(new ContextItem("", text(search_node), "search", -1, client.getClient(contextLink)));
         } else if (contextLink.rel().get().equals("perspective"))
         {
            list.add(new ContextItem("", contextLink.text().get(), contextLink.rel().get(), -1, client.getClient(contextLink)));
         } else if (contextLink.rel().get().equals("inbox"))
         {
            list.add(new ContextItem(contextLink.text().get(), text(inboxes_node), "inbox", -1, client.getClient(contextLink)));
         } else if (contextLink.rel().get().equals("assignments"))
         {
            list.add(new ContextItem(contextLink.text().get(), text(assignments_node), "assign", -1, client.getClient(contextLink)));
         }
      }

      EventListSynch.synchronize( Collections.<ContextItem>emptyList(), items );
      EventListSynch.synchronize( list, items );

      applyCounts();
   }

   protected void applyCounts()
   {
      if (caseCounts != null)
      {
         for (LinkValue linkValue : caseCounts.links().get())
         {
            items.getReadWriteLock().writeLock().lock();
            try
            {
               for (int i = 0; i < items.size(); i++)
               {
                  ContextItem item = items.get(i);
                  Reference reference = item.getClient().getReference();
                  String ref = reference.getPath();
                  if (ref.endsWith("user/drafts/")) // This is a hack. Not sure why user and project references are different...
                     ref = "user/drafts";
                  else
                     ref = ref.substring(0, ref.length() - 1);
                  if (ref.endsWith(linkValue.id().get()))
                  {
                     item.setCount(Long.valueOf(linkValue.text().get()));
                     items.set(i, item);
                     break;
                  }
               }
            } finally
            {
               items.getReadWriteLock().writeLock().unlock();
            }
         }
      }
   }
}
