/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.war;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.war.AbstractWarMojo;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.Manifest;
import org.codehaus.plexus.archiver.jar.ManifestException;
import org.codehaus.plexus.archiver.war.WarArchiver;

public class WarManifestMojo
extends AbstractWarMojo {
    private WarArchiver warArchiver;
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        File manifestDir = new File(this.getWarSourceDirectory(), "META-INF");
        if (!manifestDir.exists()) {
            manifestDir.mkdirs();
        }
        File manifestFile = new File(manifestDir, "MANIFEST.MF");
        MavenArchiver ma = new MavenArchiver();
        ma.setArchiver((JarArchiver)this.warArchiver);
        ma.setOutputFile(manifestFile);
        try {
            Manifest mf = ma.getManifest(this.getProject(), this.archive.getManifest());
            FileWriter fileWriter = new FileWriter(manifestFile);
            PrintWriter printWriter = new PrintWriter(fileWriter);
            try {
                mf.write(printWriter);
            }
            finally {
                printWriter.close();
                fileWriter.close();
            }
        }
        catch (ManifestException e) {
            throw new MojoExecutionException("Error preparing the manifest", (Exception)((Object)e));
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Error preparing the manifest", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error preparing the manifest", (Exception)e);
        }
    }
}

