/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.war;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractWarMojo
extends AbstractMojo {
    private MavenProject project;
    private File classesDirectory;
    private File webappDirectory;
    private File warSourceDirectory;
    private String webXml;
    private File workDirectory;
    protected ArchiverManager archiverManager;
    public static final String WEB_INF = "WEB-INF";
    private String warSourceIncludes = "**";
    private String warSourceExcludes;
    private String dependentWarIncludes = "**";
    private String dependentWarExcludes;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public abstract void execute() throws MojoExecutionException;

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public File getClassesDirectory() {
        return this.classesDirectory;
    }

    public void setClassesDirectory(File classesDirectory) {
        this.classesDirectory = classesDirectory;
    }

    public File getWebappDirectory() {
        return this.webappDirectory;
    }

    public void setWebappDirectory(File webappDirectory) {
        this.webappDirectory = webappDirectory;
    }

    public File getWarSourceDirectory() {
        return this.warSourceDirectory;
    }

    public void setWarSourceDirectory(File warSourceDirectory) {
        this.warSourceDirectory = warSourceDirectory;
    }

    public String getWebXml() {
        return this.webXml;
    }

    public void setWebXml(String webXml) {
        this.webXml = webXml;
    }

    protected String[] getExcludes() {
        ArrayList<String> excludeList = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)this.warSourceExcludes)) {
            excludeList.addAll(Arrays.asList(StringUtils.split((String)this.warSourceExcludes, (String)",")));
        }
        if (this.getWebXml() != null && !"".equals(this.getWebXml())) {
            excludeList.add("**/WEB-INF/web.xml");
        }
        return excludeList.toArray(EMPTY_STRING_ARRAY);
    }

    protected String[] getIncludes() {
        return StringUtils.split((String)StringUtils.defaultString((Object)this.warSourceIncludes), (String)",");
    }

    protected String[] getDependentWarExcludes() {
        if (StringUtils.isNotEmpty((String)this.dependentWarExcludes)) {
            return StringUtils.split((String)this.dependentWarExcludes, (String)",");
        }
        return (String[])EMPTY_STRING_ARRAY.clone();
    }

    protected String[] getDependentWarIncludes() {
        return StringUtils.split((String)StringUtils.defaultString((Object)this.dependentWarIncludes), (String)",");
    }

    public void buildExplodedWebapp(File webappDirectory) throws MojoExecutionException {
        this.getLog().info((CharSequence)"Exploding webapp...");
        webappDirectory.mkdirs();
        File webinfDir = new File(webappDirectory, WEB_INF);
        webinfDir.mkdirs();
        try {
            this.copyResources(this.getWarSourceDirectory(), webappDirectory, this.getWebXml());
            this.buildWebapp(this.getProject(), webappDirectory);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not explode webapp...", (Exception)e);
        }
    }

    public void copyResources(File sourceDirectory, File webappDirectory, String webXml) throws IOException {
        if (!sourceDirectory.equals(webappDirectory)) {
            this.getLog().info((CharSequence)("Copy webapp resources to " + webappDirectory.getAbsolutePath()));
            if (this.getWarSourceDirectory().exists()) {
                String[] fileNames = this.getWarFiles(sourceDirectory);
                for (int i = 0; i < fileNames.length; ++i) {
                    FileUtils.copyFile((File)new File(sourceDirectory, fileNames[i]), (File)new File(webappDirectory, fileNames[i]));
                }
            }
            if (webXml != null && !"".equals(webXml)) {
                File webinfDir = new File(webappDirectory, WEB_INF);
                FileUtils.copyFile((File)new File(webXml), (File)new File(webinfDir, "/web.xml"));
            }
        }
    }

    public void buildWebapp(MavenProject project, File webappDirectory) throws MojoExecutionException, IOException {
        this.getLog().info((CharSequence)("Assembling webapp " + project.getArtifactId() + " in " + webappDirectory));
        File libDirectory = new File(webappDirectory, "WEB-INF/lib");
        File tldDirectory = new File(webappDirectory, "WEB-INF/tld");
        File webappClassesDirectory = new File(webappDirectory, "WEB-INF/classes");
        if (this.getClassesDirectory().exists() && !this.getClassesDirectory().equals(webappClassesDirectory)) {
            FileUtils.copyDirectoryStructure((File)this.getClassesDirectory(), (File)webappClassesDirectory);
        }
        Set artifacts = project.getArtifacts();
        ArrayList<File> dependentWarDirectories = new ArrayList<File>();
        Iterator iter = artifacts.iterator();
        while (iter.hasNext()) {
            Artifact artifact = (Artifact)iter.next();
            ScopeArtifactFilter filter = new ScopeArtifactFilter("runtime");
            if (artifact.isOptional() || !filter.include(artifact)) continue;
            String type = artifact.getType();
            if ("tld".equals(type)) {
                FileUtils.copyFileToDirectory((File)artifact.getFile(), (File)tldDirectory);
                continue;
            }
            if ("jar".equals(type) || "ejb".equals(type) || "ejb-client".equals(type)) {
                FileUtils.copyFileToDirectory((File)artifact.getFile(), (File)libDirectory);
                continue;
            }
            if ("war".equals(type)) {
                dependentWarDirectories.add(this.unpackWarToTempDirectory(artifact));
                continue;
            }
            this.getLog().debug((CharSequence)("Skipping artifact of type " + type + " for WEB-INF/lib"));
        }
        if (dependentWarDirectories.size() > 0) {
            this.getLog().info((CharSequence)("Overlaying " + dependentWarDirectories.size() + " war(s)."));
            iter = dependentWarDirectories.iterator();
            while (iter.hasNext()) {
                this.copyDependentWarContents((File)iter.next(), webappDirectory);
            }
        }
    }

    private File unpackWarToTempDirectory(Artifact artifact) throws MojoExecutionException {
        String name = artifact.getFile().getName();
        File tempLocation = new File(this.workDirectory, name.substring(0, name.length() - 4));
        boolean process = false;
        if (!tempLocation.exists()) {
            tempLocation.mkdirs();
            process = true;
        } else if (artifact.getFile().lastModified() > tempLocation.lastModified()) {
            process = true;
        }
        if (process) {
            File file = artifact.getFile();
            try {
                this.unpack(file, tempLocation);
            }
            catch (NoSuchArchiverException e) {
                this.getLog().info((CharSequence)("Skip unpacking dependency file with unknown extension: " + file.getPath()));
            }
        }
        return tempLocation;
    }

    private void unpack(File file, File location) throws MojoExecutionException, NoSuchArchiverException {
        String archiveExt = FileUtils.getExtension((String)file.getAbsolutePath()).toLowerCase();
        try {
            UnArchiver unArchiver = this.archiverManager.getUnArchiver(archiveExt);
            unArchiver.setSourceFile(file);
            unArchiver.setDestDirectory(location);
            unArchiver.extract();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error unpacking file: " + file + "to: " + location, (Exception)e);
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Error unpacking file: " + file + "to: " + location, (Exception)((Object)e));
        }
    }

    private void copyDependentWarContents(File srcDir, File targetDir) throws MojoExecutionException {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(srcDir);
        scanner.setExcludes(this.getDependentWarExcludes());
        scanner.addDefaultExcludes();
        scanner.setIncludes(this.getDependentWarIncludes());
        scanner.scan();
        String[] dirs = scanner.getIncludedDirectories();
        for (int j = 0; j < dirs.length; ++j) {
            new File(targetDir, dirs[j]).mkdirs();
        }
        String[] files = scanner.getIncludedFiles();
        for (int j = 0; j < files.length; ++j) {
            File targetFile = new File(targetDir, files[j]);
            if (targetFile.exists()) continue;
            try {
                targetFile.getParentFile().mkdirs();
                FileUtils.copyFile((File)new File(srcDir, files[j]), (File)targetFile);
                continue;
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error copying file '" + files[j] + "' to '" + targetFile + "'", (Exception)e);
            }
        }
    }

    private String[] getWarFiles(File sourceDir) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(sourceDir);
        scanner.setExcludes(this.getExcludes());
        scanner.addDefaultExcludes();
        scanner.setIncludes(this.getIncludes());
        scanner.scan();
        return scanner.getIncludedFiles();
    }
}

