/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class SimpleDate
implements Comparable<SimpleDate> {
    private final int year;
    private final int month;
    private final int date;

    public SimpleDate(Date dateTime) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(dateTime);
        this.year = calendar.get(1);
        this.month = calendar.get(2);
        this.date = calendar.get(5);
    }

    public SimpleDate(int year, int month, int date) {
        this.year = year;
        this.month = month - 1;
        this.date = date;
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month + 1;
    }

    public int getDate() {
        return this.date;
    }

    public SimpleDate() {
        this(new Date());
    }

    public String toString() {
        return new SimpleDateFormat("yyyy-MM-dd").format(this.toDate());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleDate that = (SimpleDate)o;
        return this.year == that.year && this.month == that.month && this.date == that.date;
    }

    public int hashCode() {
        int result = this.year;
        result = 29 * result + this.month;
        result = 29 * result + this.date;
        return result;
    }

    @Override
    public int compareTo(SimpleDate o) {
        int difference = new Integer(this.year).compareTo(new Integer(o.year));
        if (0 == difference) {
            difference = new Integer(this.month).compareTo(new Integer(o.month));
        }
        if (0 == difference) {
            difference = new Integer(this.date).compareTo(new Integer(o.date));
        }
        return difference;
    }

    public Date toDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, this.year);
        calendar.set(2, this.month);
        calendar.set(5, this.date);
        return calendar.getTime();
    }
}

