/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.util;

import java.util.AbstractList;
import java.util.List;

public class ListPartitions<E>
extends AbstractList<List<E>> {
    private final List<E> list;
    private final int partitionSize;

    public ListPartitions(List<E> list, int partitionSize) {
        if (partitionSize <= 0) {
            throw new IllegalArgumentException();
        }
        this.partitionSize = partitionSize;
        this.list = list;
    }

    @Override
    public int size() {
        return Math.max(1, (int)Math.ceil((double)this.list.size() / (double)this.partitionSize));
    }

    @Override
    public List<E> get(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("Index " + index + " out of bounds 0-" + this.size() + ".");
        }
        int fromIndex = index * this.partitionSize;
        int toIndex = Math.min(fromIndex + this.partitionSize, this.list.size());
        return this.list.subList(fromIndex, toIndex);
    }
}

