/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.util;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class CompositeList<E>
extends AbstractList<E> {
    private final List<List<E>> lists = Collections.synchronizedList(new ArrayList());

    @Override
    public E get(int index) {
        return this.operateOnIndex(index, new ListIndexOperation<E>(){

            @Override
            public E operate(List<E> list, int index) {
                return list.get(index);
            }
        });
    }

    @Override
    public E remove(int index) {
        return this.operateOnIndex(index, new ListIndexOperation<E>(){

            @Override
            public E operate(List<E> list, int index) {
                return list.remove(index);
            }
        });
    }

    @Override
    public E set(int index, final E element) {
        return this.operateOnIndex(index, new ListIndexOperation<E>(){

            @Override
            public E operate(List<E> list, int index) {
                return list.set(index, element);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private E operateOnIndex(int index, ListIndexOperation<E> listIndexOperation) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("" + index);
        }
        List<List<E>> list = this.lists;
        synchronized (list) {
            int firstIndexInList = 0;
            Iterator<List<E>> i$ = this.lists.iterator();
            while (i$.hasNext()) {
                int indexInList = index - firstIndexInList;
                List<E> list2 = i$.next();
                if (indexInList < list2.size()) {
                    return listIndexOperation.operate(list2, indexInList);
                }
                firstIndexInList += list2.size();
            }
        }
        throw new IndexOutOfBoundsException("" + index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        List<List<E>> list = this.lists;
        synchronized (list) {
            int size = 0;
            for (List<E> list2 : this.lists) {
                size += list2.size();
            }
            return size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object o) {
        List<List<E>> list = this.lists;
        synchronized (list) {
            for (List<E> list2 : this.lists) {
                if (!list2.contains(o)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addList(List list) {
        List<List<E>> list2 = this.lists;
        synchronized (list2) {
            this.lists.add(list);
        }
    }

    private static interface ListIndexOperation<E> {
        public E operate(List<E> var1, int var2);
    }
}

