package com.imcode.util ;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.ServletException;
import java.io.IOException;

public class Page {

    private String path ;

    protected Page(String path) {
        this.path = path;
    }

    protected static Page getPageFromRequest(HttpServletRequest request) {
        return (Page) request.getAttribute(getAttributeName(Page.class)) ;
    }

    protected static Page getPageFromRequest(HttpServletRequest request, Class<? extends Page> aClass) {
        return (Page) request.getAttribute(getAttributeName(aClass)) ;
    }

    public void forward(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        setRequestAttribute(request, this);
        request.getRequestDispatcher(path).forward(request, response);
    }

    public void include(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Object previousValue = setRequestAttribute(request, this);
        request.getRequestDispatcher(path).include(request, response);
        if (null != previousValue) {
            setRequestAttribute(request, previousValue) ;
        }
    }

    public static String getPath(Page page) {
        return page.path ;
    }
    
    public static Object setRequestAttribute(HttpServletRequest request, Object value) {
        Class<? extends Object> aClass = value.getClass();
        Object previousValue = request.getAttribute(getAttributeName(aClass)) ;
        request.setAttribute(getAttributeName(aClass), value);
        return previousValue ;
    }

    private static String getAttributeName(Class<? extends Object> aClass) {
        return aClass.getName();
    }

    public void initFromRequest(HttpServletRequest request) {

    }

}
