package com.imcode.util;

import java.util.AbstractList;
import java.util.List;

public class ListPartitions<E> extends AbstractList<List<E>> {

    private final List<E> list;
    private final int partitionSize;

    public ListPartitions(List<E> list, int partitionSize) {
        if (partitionSize <= 0) {
            throw new IllegalArgumentException() ;
        }
        this.partitionSize = partitionSize;
        this.list = list;
    }

    public int size() {
        return Math.max(1, (int)Math.ceil((double)list.size() / partitionSize)) ;
    }

    public List<E> get(int index) {
        if (index < 0 || index >= size()) {
            throw new IndexOutOfBoundsException("Index "+index+" out of bounds 0-"+size()+".") ;
        }
        int fromIndex = index * partitionSize;
        int toIndex = Math.min(fromIndex+partitionSize, list.size()) ;
        return list.subList(fromIndex, toIndex) ;
    }

}
