package com.imcode.util;

import org.apache.commons.lang.StringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class KeywordsParser {

    public String[] parseKeywords(String keywordsString) {
        List<String> keywords = new ArrayList<String>();
        StringBuffer currentKeyword = new StringBuffer();
        boolean insideString = false;
        for (int i = 0; i < keywordsString.length(); ++i) {
            char c = keywordsString.charAt(i);
            if ('"' == c) {
                insideString = !insideString;
            } else if (isKeywordCharacter(c) || insideString) {
                currentKeyword.append(c);
            } else if (0 < currentKeyword.length()) {
                keywords.add(currentKeyword.toString());
                currentKeyword.setLength(0);
            }
        }
        if (0 < currentKeyword.length()) {
            keywords.add(currentKeyword.toString());
        }
        return keywords.toArray(new String[keywords.size()]);
    }

    protected boolean isKeywordCharacter(char c) {
        return Character.isLetterOrDigit(c);
    }

    public String formatKeywords(String[] keywords) {

        for (int i = 0; i < keywords.length; i++) {
            if (Pattern.compile("[^\\p{L}\\d]").matcher(keywords[i]).find()) {
                keywords[i] = '"' + keywords[i] + '"';
            }
        }
        return StringUtils.join(keywords, ", ");
    }


}
