package com.imcode.util;

import java.util.Calendar;
import java.util.Date;
import java.text.SimpleDateFormat;

public class SimpleDate implements Comparable<SimpleDate> {

    private final int year ;
    private final int month ;
    private final int date ;

    public SimpleDate(Date dateTime) {
        Calendar calendar = Calendar.getInstance() ;
        calendar.setTime(dateTime);
        year = calendar.get(Calendar.YEAR) ;
        month = calendar.get(Calendar.MONTH) ;
        date = calendar.get(Calendar.DATE) ;
    }

    public SimpleDate(int year, int month, int date) {
        this.year = year;
        this.month = month - 1;
        this.date = date;
    }

    public int getYear() {
        return year;
    }

    public int getMonth() {
        return month + 1;
    }

    public int getDate() {
        return date;
    }

    public SimpleDate() {
        this(new Date());
    }

    public String toString() {
        return new SimpleDateFormat("yyyy-MM-dd").format(toDate()) ;
    }

    public boolean equals(Object o) {
        if ( this == o ) {
            return true;
        }
        if ( o == null || getClass() != o.getClass() ) {
            return false;
        }

        final SimpleDate that = (SimpleDate) o;

        return year == that.year && month == that.month && date == that.date;
    }

    public int hashCode() {
        int result = year;
        result = 29 * result + month;
        result = 29 * result + date;
        return result;
    }

    public int compareTo(SimpleDate o) {
        int difference = new Integer(year).compareTo(new Integer(o.year)) ;
        if (0 == difference) {
            difference = new Integer(month).compareTo(new Integer(o.month)) ;
        }
        if (0 == difference) {
            difference = new Integer(date).compareTo(new Integer(o.date)) ;
        }
        return difference ;
    }

    public Date toDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.clear() ;
        calendar.set(Calendar.YEAR, year) ;
        calendar.set(Calendar.MONTH, month) ;
        calendar.set(Calendar.DATE, date) ;
        return calendar.getTime() ;
    }

}
