package com.imcode.util;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CompositeList<E> extends AbstractList<E> {

    private final List<List<E>> lists = Collections.synchronizedList(new ArrayList());

    public E get(int index) {
        return operateOnIndex(index, new ListIndexOperation<E>() {
            public E operate(List<E> list, int index) {
                return list.get(index);
            }
        });
    }

    public E remove(int index) {
        return operateOnIndex(index, new ListIndexOperation<E>() {
            public E operate(List<E> list, int index) {
                return list.remove(index);
            }
        });
    }

    public E set(int index, final E element) {
        return operateOnIndex(index, new ListIndexOperation<E>() {
            public E operate(List<E> list, int index) {
                return list.set(index, element);
            }
        });
    }

    private E operateOnIndex(int index, ListIndexOperation<E> listIndexOperation) {
        if ( index < 0 ) {
            throw new IndexOutOfBoundsException("" + index);
        }
        synchronized ( lists ) {
            int firstIndexInList = 0;
            for ( List list : lists ) {
                int indexInList = index - firstIndexInList;
                if ( indexInList < list.size() ) {
                    return listIndexOperation.operate(list, indexInList);
                }
                firstIndexInList += list.size();
            }
        }
        throw new IndexOutOfBoundsException("" + index);
    }

    public int size() {
        synchronized ( lists ) {
            int size = 0;
            for ( List list : lists ) {
                size += list.size();
            }
            return size;
        }
    }

    public boolean contains(Object o) {
        synchronized (lists) {
            for ( List list : lists ) {
                if ( list.contains(o) ) {
                    return true;
                }
            }
        }
        return false;
    }

    public void addList(List list) {
        synchronized (lists) {
            lists.add(list);
        }
    }

    private static interface ListIndexOperation<E> {

        E operate(List<E> list, int index);
    }

}
