package com.imcode.util;

import org.apache.commons.collections.ComparatorUtils;

import java.util.Comparator;
import java.io.Serializable;

public abstract class ChainableReversibleNullComparator<E> implements Comparator<E>, Serializable {

    public ChainableReversibleNullComparator<E> chain( Comparator<E> comparator ) {
        return new ComparatorWrapper<E>( ComparatorUtils.chainedComparator( this, comparator ) );
    }

    public ChainableReversibleNullComparator<E> reversed() {
        return new ComparatorWrapper<E>( ComparatorUtils.reversedComparator( this ) );
    }

    public ChainableReversibleNullComparator<E> nullsFirst() {
        return new ComparatorWrapper<E>( this ) {
            public int compare( E o1, E o2 ) {
                try {
                    return super.compare( o1, o2 );
                } catch (NullPointerException npe) {
                    return compareNulls( wrappedComparator, o1, o2 );
                }
            }
        };
    }

    public ChainableReversibleNullComparator<E> nullsLast() {
        return new ComparatorWrapper<E>( this ) {
            public int compare( E o1, E o2 ) {
                try {
                    return super.compare( o1, o2 );
                } catch (NullPointerException npe) {
                    return -compareNulls( wrappedComparator, o1, o2 );
                }
            }
        };
    }

    private int compareNulls( Comparator<E> comparator, E o1, E o2 ) {
        boolean value1IsNull = tryCompareNull(comparator, o1);
        boolean value2IsNull = tryCompareNull(comparator, o2);
        if ( value1IsNull && value2IsNull ) {
            return 0;
        } else if ( value1IsNull ) {
            return -1;
        } else if ( value2IsNull ) {
            return +1;
        }
        return 0 ;
    }

    private boolean tryCompareNull(Comparator<E> comparator, E o) {
        boolean isNull = false;
        try {
            comparator.compare( o, o );
        } catch ( NullPointerException npe ) {
            isNull = true;
        }
        return isNull;
    }

}