/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.util;

import com.imcode.util.ComparatorWrapper;
import java.io.Serializable;
import java.util.Comparator;
import org.apache.commons.collections.ComparatorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ChainableReversibleNullComparator<E>
implements Comparator<E>,
Serializable {
    public ChainableReversibleNullComparator<E> chain(Comparator<E> comparator) {
        return new ComparatorWrapper(ComparatorUtils.chainedComparator((Comparator)this, comparator));
    }

    @Override
    public ChainableReversibleNullComparator<E> reversed() {
        return new ComparatorWrapper(ComparatorUtils.reversedComparator((Comparator)this));
    }

    public ChainableReversibleNullComparator<E> nullsFirst() {
        return new ComparatorWrapper<E>(this){

            @Override
            public int compare(E o1, E o2) {
                try {
                    return super.compare(o1, o2);
                }
                catch (NullPointerException npe) {
                    return ChainableReversibleNullComparator.this.compareNulls(this.wrappedComparator, o1, o2);
                }
            }
        };
    }

    public ChainableReversibleNullComparator<E> nullsLast() {
        return new ComparatorWrapper<E>(this){

            @Override
            public int compare(E o1, E o2) {
                try {
                    return super.compare(o1, o2);
                }
                catch (NullPointerException npe) {
                    return -ChainableReversibleNullComparator.this.compareNulls(this.wrappedComparator, o1, o2);
                }
            }
        };
    }

    private int compareNulls(Comparator<E> comparator, E o1, E o2) {
        boolean value1IsNull = this.tryCompareNull(comparator, o1);
        boolean value2IsNull = this.tryCompareNull(comparator, o2);
        if (value1IsNull && value2IsNull) {
            return 0;
        }
        if (value1IsNull) {
            return -1;
        }
        if (value2IsNull) {
            return 1;
        }
        return 0;
    }

    private boolean tryCompareNull(Comparator<E> comparator, E o) {
        boolean isNull = false;
        try {
            comparator.compare(o, o);
        }
        catch (NullPointerException npe) {
            isNull = true;
        }
        return isNull;
    }
}

