/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.net.ldap;

import com.imcode.net.ldap.LdapAuthenticationException;
import com.imcode.net.ldap.LdapClientException;
import com.imcode.net.ldap.LdapConnectionImpl;
import com.imcode.net.ldap.LdapConnectionPool;
import java.util.Hashtable;
import java.util.concurrent.TimeUnit;
import javax.naming.NamingException;
import javax.naming.ldap.LdapContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LdapClient {
    private static final Logger LOG = LogManager.getLogger(LdapConnectionImpl.class);
    private final String ldapUrl;

    public LdapClient(String ldapUrl) {
        this.ldapUrl = ldapUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canBind(String ldapBindDn, String ldapPassword) throws LdapClientException {
        Hashtable<String, String> env = LdapConnectionPool.createLdapJndiEnvironment(this.ldapUrl, ldapBindDn, ldapPassword, "5000");
        LdapContext ldapContext = null;
        try {
            ldapContext = LdapConnectionPool.createLdapContext(env);
            boolean bl = true;
            return bl;
        }
        catch (LdapAuthenticationException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (ldapContext != null) {
                try {
                    ldapContext.close();
                }
                catch (NamingException e) {
                    LOG.warn("", (Throwable)e);
                }
            }
        }
    }

    public LdapConnectionPool bind(String ldapBindDn, String ldapPassword, String readTimeout, int connectionsNumber, int expiry, TimeUnit expiryTimeUnit) throws LdapClientException {
        return new LdapConnectionPool(this.ldapUrl, ldapBindDn, ldapPassword, readTimeout, connectionsNumber, expiry, expiryTimeUnit);
    }

    public String getLdapUrl() {
        return this.ldapUrl;
    }
}

