package com.imcode.net.ldap;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import javax.naming.NamingException;
import javax.naming.ldap.LdapContext;
import java.util.Hashtable;
import java.util.concurrent.TimeUnit;

public class LdapClient {

    private static final Logger LOG = LogManager.getLogger(LdapConnectionImpl.class);

    private final String ldapUrl;

    public LdapClient(String ldapUrl) {
        this.ldapUrl = ldapUrl;
    }

    public boolean canBind(final String ldapBindDn, final String ldapPassword) throws LdapClientException {
        final Hashtable<String, String> env = LdapConnectionPool.createLdapJndiEnvironment(ldapUrl, ldapBindDn, ldapPassword, "5000");
        LdapContext ldapContext = null;
        try {
            ldapContext = LdapConnectionPool.createLdapContext(env);
            return true;
        } catch (LdapAuthenticationException e) {
            return false;
        } finally {
            if (ldapContext != null) {
                try {
                    ldapContext.close();
                } catch (NamingException e) {
                    LOG.warn("", e);
                }
            }
        }
    }

    public LdapConnectionPool bind(final String ldapBindDn,
                                   final String ldapPassword,
                                   final String readTimeout,
                                   final int connectionsNumber,
                                   final int expiry, TimeUnit expiryTimeUnit) throws LdapClientException {
        return new LdapConnectionPool(ldapUrl, ldapBindDn, ldapPassword, readTimeout, connectionsNumber, expiry, expiryTimeUnit);
    }

    public String getLdapUrl() {
        return ldapUrl;
    }

}
