package com.imcode.net.ldap;

import javax.naming.directory.SearchControls;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public interface LdapConnection {

    String DISTINGUISHED_NAME = "dn";
    String COMMON_NAME = "cn";

    Iterator<Map<String, String>> search(String searchFilterExpr, Object[] parameters,
                                         SearchControls searchControls) throws LdapClientException;

    Iterator<Map<String, Set<String>>> searchMultivalues(String searchFilterExpr, Object[] parameters,
                                                         SearchControls searchControls) throws LdapClientException;

    Set<String> getADUserGroups(final String sAMAccountName) throws LdapClientException;

	Set<String> getUserGroups(String loginName);

    void close() throws LdapClientException;
}
