/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.net.ldap;

import com.imcode.net.ldap.LdapAuthenticationException;
import com.imcode.net.ldap.LdapClientException;
import com.imcode.net.ldap.LdapConnection;
import com.imcode.net.ldap.LdapConnectionImpl;
import java.util.Date;
import java.util.Hashtable;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.naming.AuthenticationException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;

public class LdapConnectionPool {
    private static AtomicBoolean init = new AtomicBoolean(false);
    private static AtomicLong expiresInMillis = new AtomicLong(0L);
    private static BlockingQueue<LdapConnectionImpl> connectionPool;
    private static Semaphore connectionLimiter;
    private static Hashtable<String, String> env;

    public LdapConnectionPool(String ldapUrl, String ldapBindDn, String ldapPassword, String readTimeout, int connectionsNumber, int expiry, TimeUnit expiryTimeUnit) {
        if (!init.get()) {
            LdapConnectionPool.init(ldapUrl, ldapBindDn, ldapPassword, readTimeout, connectionsNumber, expiry, expiryTimeUnit);
        }
    }

    public LdapConnection getConnection() throws LdapClientException {
        boolean connectionIsNull;
        try {
            connectionLimiter.acquire();
        }
        catch (InterruptedException e) {
            throw new LdapClientException("", e);
        }
        LdapConnectionImpl connection = (LdapConnectionImpl)connectionPool.poll();
        boolean bl = connectionIsNull = connection == null;
        if (connectionIsNull || connection.isExpired()) {
            if (!connectionIsNull) {
                connection.close();
            }
            connection = new LdapConnectionImpl(LdapConnectionPool.createLdapContext(env), this.calcExpiry()){

                @Override
                public void close() throws LdapClientException {
                    try {
                        connectionPool.put(this);
                    }
                    catch (InterruptedException e) {
                        throw new LdapClientException("", e);
                    }
                    connectionLimiter.release();
                }
            };
        }
        return connection;
    }

    private Date calcExpiry() {
        return new Date(System.currentTimeMillis() + expiresInMillis.get());
    }

    private static synchronized void init(String ldapUrl, String ldapBindDn, String ldapPassword, String readTimeout, int connectionsNumber, int expiry, TimeUnit expiryTimeUnit) {
        connectionPool = new LinkedBlockingQueue<LdapConnectionImpl>(connectionsNumber);
        connectionLimiter = new Semaphore(connectionsNumber, true);
        env = LdapConnectionPool.createLdapJndiEnvironment(ldapUrl, ldapBindDn, ldapPassword, readTimeout);
        expiresInMillis.set(expiryTimeUnit.toMillis(expiry));
        init.set(true);
    }

    static LdapContext createLdapContext(Hashtable<String, String> env) throws LdapClientException {
        try {
            return new InitialLdapContext(env, null);
        }
        catch (AuthenticationException ex) {
            throw new LdapAuthenticationException("Authentication failed, using login: '" + env.get("java.naming.security.principal") + "'", ex);
        }
        catch (NameNotFoundException ex) {
            throw new LdapClientException("Root not found: " + env.get("java.naming.provider.url"), ex);
        }
        catch (NamingException ex) {
            throw LdapConnectionPool.wrapNamingException(env.get("java.naming.provider.url"), ex);
        }
    }

    static Hashtable<String, String> createLdapJndiEnvironment(String ldapUrl, String ldapBindDn, String ldapPassword, String readTimeout) {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("com.sun.jndi.ldap.read.timeout", readTimeout);
        env.put("java.naming.provider.url", ldapUrl);
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", ldapBindDn);
        env.put("java.naming.security.credentials", ldapPassword);
        env.put("java.naming.referral", "follow");
        env.put("java.naming.ldap.attributes.binary", "tokenGroups");
        return env;
    }

    private static LdapClientException wrapNamingException(String ldapUrl, NamingException ex) {
        return new LdapClientException("Failed to create LDAP context " + ldapUrl + ": " + ex.getExplanation(), ex);
    }
}

