/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.net.ldap;

import com.imcode.net.ldap.LdapClientException;
import com.imcode.net.ldap.LdapConnection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.naming.CommunicationException;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.LdapName;
import org.apache.commons.collections.map.CaseInsensitiveMap;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.UnhandledException;
import org.apache.log4j.Logger;

public abstract class LdapConnectionImpl
implements LdapConnection {
    private static final Logger LOG = Logger.getLogger(LdapConnectionImpl.class);
    static final String AUTHENTICATION_TYPE_SIMPLE = "simple";
    private static final String EMPTY_NAME = "";
    private final LdapContext ldapContext;
    private final Date expiryDate;

    public LdapConnectionImpl(LdapContext ldapContext, Date expiryDate) {
        this.ldapContext = ldapContext;
        this.expiryDate = expiryDate;
    }

    @Override
    public Iterator<Map<String, String>> search(String searchFilterExpr, Object[] parameters, SearchControls searchControls) throws LdapClientException {
        try {
            try {
                return this.trySearch(searchFilterExpr, parameters, searchControls);
            }
            catch (CommunicationException ce) {
                LOG.warn((Object)"Problem communicating with LDAP server, retrying.", (Throwable)ce);
                return this.trySearch(searchFilterExpr, parameters, searchControls);
            }
        }
        catch (NamingException ne) {
            throw new LdapClientException("LDAP search failed.", ne);
        }
    }

    @Override
    public Iterator<Map<String, Set<String>>> searchMultivalues(String searchFilterExpr, Object[] parameters, SearchControls searchControls) throws LdapClientException {
        try {
            try {
                return this.trySearchMultivalues(searchFilterExpr, parameters, searchControls);
            }
            catch (CommunicationException ce) {
                LOG.warn((Object)"Problem communicating with LDAP server, retrying.", (Throwable)ce);
                return this.trySearchMultivalues(searchFilterExpr, parameters, searchControls);
            }
        }
        catch (NamingException ne) {
            throw new LdapClientException("LDAP search failed.", ne);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getADUserGroups(String sAMAccountName) throws LdapClientException {
        String userDn = this.getADUserDn(sAMAccountName);
        if (userDn == null) {
            return Collections.emptySet();
        }
        HashSet<String> groups = new HashSet<String>();
        SearchControls userSearchCtls = new SearchControls();
        userSearchCtls.setSearchScope(0);
        userSearchCtls.setReturningAttributes(new String[]{"tokenGroups"});
        try {
            NamingEnumeration<SearchResult> userAnswer = null;
            NamingEnumeration<SearchResult> groupsAnswer = null;
            try {
                LdapName userDnName = new LdapName(userDn);
                LdapName ctxName = new LdapName(this.ldapContext.getNameInNamespace());
                Name name = userDnName.getSuffix(ctxName.size());
                userAnswer = this.ldapContext.search(name, "(objectClass=user)", userSearchCtls);
                StringBuilder groupsSearchFilter = new StringBuilder();
                groupsSearchFilter.append("(|");
                while (userAnswer.hasMoreElements()) {
                    SearchResult sr = (SearchResult)userAnswer.nextElement();
                    Attributes attrs = sr.getAttributes();
                    if (attrs == null) continue;
                    NamingEnumeration<? extends Attribute> ae = attrs.getAll();
                    while (ae.hasMoreElements()) {
                        Attribute attr = (Attribute)ae.nextElement();
                        NamingEnumeration<?> e = attr.getAll();
                        while (e.hasMoreElements()) {
                            byte[] sid = (byte[])e.nextElement();
                            groupsSearchFilter.append("(objectSid=" + LdapConnectionImpl.binarySidToStringSid(sid) + ")");
                        }
                    }
                }
                groupsSearchFilter.append(")");
                SearchControls groupsSearchCtls = new SearchControls();
                groupsSearchCtls.setSearchScope(2);
                groupsSearchCtls.setReturningAttributes(new String[]{"sAMAccountName"});
                groupsAnswer = this.ldapContext.search(EMPTY_NAME, groupsSearchFilter.toString(), groupsSearchCtls);
                while (groupsAnswer.hasMoreElements()) {
                    SearchResult sr = (SearchResult)groupsAnswer.nextElement();
                    Attributes attrs = sr.getAttributes();
                    if (attrs == null) continue;
                    groups.add(attrs.get("sAMAccountName").get().toString());
                }
            }
            finally {
                if (userAnswer != null) {
                    userAnswer.close();
                }
                if (groupsAnswer != null) {
                    groupsAnswer.close();
                }
            }
        }
        catch (NamingException e) {
            throw new LdapClientException(EMPTY_NAME, e);
        }
        return groups;
    }

    private String getADUserDn(final String sAMAccountName) throws LdapClientException {
        return this.executeWitReconnect(new LdapCommand<String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String execute() throws NamingException, LdapClientException {
                String searchFilter = "(&(objectClass=user)(sAMAccountName={0}))";
                SearchControls searchCtls = new SearchControls();
                searchCtls.setReturningAttributes(new String[0]);
                searchCtls.setSearchScope(2);
                NamingEnumeration<SearchResult> result = null;
                try {
                    result = LdapConnectionImpl.this.ldapContext.search(LdapConnectionImpl.EMPTY_NAME, searchFilter, new Object[]{sAMAccountName}, searchCtls);
                    String dn = null;
                    if (result.hasMoreElements()) {
                        dn = ((SearchResult)result.nextElement()).getNameInNamespace();
                    }
                    String string = dn;
                    return string;
                }
                finally {
                    if (result != null) {
                        result.close();
                    }
                }
            }
        });
    }

    public boolean isExpired() {
        return new Date().after(this.expiryDate);
    }

    private static String binarySidToStringSid(byte[] SID) {
        String strSID = EMPTY_NAME;
        strSID = "S";
        long version = SID[0];
        strSID = strSID + "-" + Long.toString(version);
        long authority = SID[4];
        for (int i = 0; i < 4; ++i) {
            authority <<= 8;
            authority += (long)(SID[4 + i] & 0xFF);
        }
        strSID = strSID + "-" + Long.toString(authority);
        long count = SID[2];
        count <<= 8;
        count += (long)(SID[1] & 0xFF);
        int j = 0;
        while ((long)j < count) {
            long rid = SID[11 + j * 4] & 0xFF;
            for (int k = 1; k < 4; ++k) {
                rid <<= 8;
                rid += (long)(SID[11 - k + j * 4] & 0xFF);
            }
            strSID = strSID + "-" + Long.toString(rid);
            ++j;
        }
        return strSID;
    }

    private <T> T executeWitReconnect(LdapCommand<T> ldapCommand) throws LdapClientException {
        return this.executeWitReconnect(ldapCommand, 2);
    }

    private <T> T executeWitReconnect(LdapCommand<T> ldapCommand, int retryCount) throws LdapClientException {
        T result;
        try {
            result = ldapCommand.execute();
        }
        catch (CommunicationException e) {
            if (retryCount > 1) {
                result = this.executeWitReconnect(ldapCommand, retryCount - 1);
            }
            throw new LdapClientException(EMPTY_NAME, e);
        }
        catch (NamingException e) {
            throw new LdapClientException(EMPTY_NAME, e);
        }
        return result;
    }

    private Iterator<Map<String, String>> trySearch(String searchFilterExpr, Object[] parameters, SearchControls searchControls) throws NamingException, LdapClientException {
        if (null == searchControls) {
            searchControls = new SearchControls();
        }
        searchControls.setReturningObjFlag(true);
        NamingEnumeration<SearchResult> enumeration = this.ldapContext.search(EMPTY_NAME, searchFilterExpr, parameters, searchControls);
        return new SearchResultIterator(enumeration, searchControls);
    }

    private Iterator<Map<String, Set<String>>> trySearchMultivalues(String searchFilterExpr, Object[] parameters, SearchControls searchControls) throws NamingException, LdapClientException {
        if (null == searchControls) {
            searchControls = new SearchControls();
        }
        searchControls.setReturningObjFlag(true);
        NamingEnumeration<SearchResult> enumeration = this.ldapContext.search(EMPTY_NAME, searchFilterExpr, parameters, searchControls);
        return new SearchMultivalueResultIterator(enumeration, searchControls);
    }

    private static interface LdapCommand<T> {
        public T execute() throws NamingException, LdapClientException;
    }

    private static class SearchMultivalueResultIterator
    implements Iterator<Map<String, Set<String>>> {
        private final NamingEnumeration<SearchResult> enumeration;
        private final SearchControls searchControls;

        SearchMultivalueResultIterator(NamingEnumeration<SearchResult> enumeration, SearchControls searchControls) {
            this.enumeration = enumeration;
            this.searchControls = searchControls;
        }

        @Override
        public boolean hasNext() {
            boolean hasMoreElements = this.enumeration.hasMoreElements();
            if (!hasMoreElements) {
                try {
                    this.enumeration.close();
                }
                catch (NamingException e) {
                    throw new UnhandledException((Throwable)e);
                }
            }
            return hasMoreElements;
        }

        @Override
        public Map<String, Set<String>> next() {
            try {
                return this.createMapFromSearchResult((SearchResult)this.enumeration.nextElement());
            }
            catch (NamingException e) {
                throw new UnhandledException((Throwable)e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<String, Set<String>> createMapFromSearchResult(SearchResult searchResult) throws NamingException {
            NamingEnumeration<? extends Attribute> attribEnum = null;
            try {
                attribEnum = searchResult.getAttributes().getAll();
                CaseInsensitiveMap attributes = new CaseInsensitiveMap();
                while (attribEnum.hasMoreElements()) {
                    Attribute attribute = (Attribute)attribEnum.nextElement();
                    String attributeName = attribute.getID();
                    NamingEnumeration<?> attributeValuesEnum = attribute.getAll();
                    HashSet attributeValues = new HashSet();
                    while (attributeValuesEnum.hasMoreElements()) {
                        attributeValues.add(attributeValuesEnum.nextElement());
                    }
                    attributes.put(attributeName, Collections.unmodifiableSet(attributeValues));
                }
                CaseInsensitiveMap caseInsensitiveMap = attributes;
                return caseInsensitiveMap;
            }
            finally {
                if (attribEnum != null) {
                    attribEnum.close();
                }
            }
        }
    }

    private static class SearchResultIterator
    implements Iterator<Map<String, String>> {
        private final NamingEnumeration<SearchResult> enumeration;
        private final SearchControls searchControls;

        SearchResultIterator(NamingEnumeration<SearchResult> enumeration, SearchControls searchControls) {
            this.enumeration = enumeration;
            this.searchControls = searchControls;
        }

        @Override
        public boolean hasNext() {
            boolean hasMoreElements = this.enumeration.hasMoreElements();
            if (!hasMoreElements) {
                try {
                    this.enumeration.close();
                }
                catch (NamingException e) {
                    throw new UnhandledException((Throwable)e);
                }
            }
            return hasMoreElements;
        }

        @Override
        public Map<String, String> next() {
            try {
                return this.createMapFromSearchResult((SearchResult)this.enumeration.nextElement());
            }
            catch (NamingException e) {
                throw new UnhandledException((Throwable)e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<String, String> createMapFromSearchResult(SearchResult searchResult) throws NamingException {
            NamingEnumeration<? extends Attribute> attribEnum = null;
            try {
                attribEnum = searchResult.getAttributes().getAll();
                CaseInsensitiveMap attributes = new CaseInsensitiveMap();
                while (attribEnum.hasMoreElements()) {
                    Attribute attribute = (Attribute)attribEnum.nextElement();
                    String attributeName = attribute.getID();
                    String attributeValue = attribute.get().toString();
                    attributes.put(attributeName, attributeValue);
                }
                if (!attributes.containsKey("dn")) {
                    boolean includeDistinguishedName;
                    boolean bl = includeDistinguishedName = null != this.searchControls && this.searchControls.getReturningObjFlag() && (null == this.searchControls.getReturningAttributes() || ArrayUtils.contains((Object[])this.searchControls.getReturningAttributes(), (Object)"dn"));
                    if (includeDistinguishedName) {
                        DirContext dirContext = null;
                        try {
                            dirContext = (DirContext)searchResult.getObject();
                            String distinguishedName = dirContext.getNameInNamespace();
                            attributes.put("dn", distinguishedName);
                        }
                        finally {
                            if (dirContext != null) {
                                dirContext.close();
                            }
                        }
                    }
                }
                CaseInsensitiveMap caseInsensitiveMap = attributes;
                return caseInsensitiveMap;
            }
            finally {
                if (attribEnum != null) {
                    attribEnum.close();
                }
            }
        }
    }
}

