/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.net.ldap;

import com.imcode.net.ldap.LdapClientException;
import com.imcode.net.ldap.LdapContextOperationWrapper;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.naming.CommunicationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.commons.collections.map.CaseInsensitiveMap;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.UnhandledException;
import org.apache.log4j.Logger;

public class LdapConnection {
    private static final Logger LOG = Logger.getLogger(LdapConnection.class);
    private static final String AUTHENTICATION_TYPE_SIMPLE = "simple";
    public static final String DISTINGUISHED_NAME = "dn";
    private final Hashtable<String, String> env;

    public LdapConnection(String ldapUrl, String ldapBindDn, String ldapPassword) throws LdapClientException {
        this.env = this.createLdapJndiEnvironment(ldapUrl, ldapBindDn, ldapPassword);
    }

    private Hashtable<String, String> createLdapJndiEnvironment(String ldapUrl, String ldapBindDn, String ldapPassword) {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("com.sun.jndi.ldap.read.timeout", "5000");
        env.put("java.naming.provider.url", ldapUrl);
        env.put("java.naming.security.authentication", AUTHENTICATION_TYPE_SIMPLE);
        env.put("java.naming.security.principal", ldapBindDn);
        env.put("java.naming.security.credentials", ldapPassword);
        env.put("java.naming.referral", "follow");
        env.put("java.naming.ldap.attributes.binary", "tokenGroups");
        env.put("com.sun.jndi.ldap.connect.pool", "true");
        env.put("com.sun.jndi.ldap.connect.pool.authentication", AUTHENTICATION_TYPE_SIMPLE);
        env.put("com.sun.jndi.ldap.connect.pool.maxsize", "20");
        env.put("com.sun.jndi.ldap.connect.pool.prefsize", "10");
        env.put("com.sun.jndi.ldap.connect.pool.timeout", "30000");
        env.put("com.sun.jndi.ldap.connect.pool.debug", "fine");
        return env;
    }

    private Iterator<Map<String, String>> trySearch(String searchFilterExpr, Object[] parameters, SearchControls searchControls) throws NamingException, LdapClientException {
        if (null == searchControls) {
            searchControls = new SearchControls();
        }
        searchControls.setReturningObjFlag(true);
        NamingEnumeration<SearchResult> enumeration = LdapContextOperationWrapper.from(this.env).searchAndClose(searchFilterExpr, parameters, searchControls);
        return new SearchResultIterator(enumeration, searchControls);
    }

    private Iterator<Map<String, Set<String>>> trySearchMultivalues(String searchFilterExpr, Object[] parameters, SearchControls searchControls) throws NamingException, LdapClientException {
        if (null == searchControls) {
            searchControls = new SearchControls();
        }
        searchControls.setReturningObjFlag(true);
        NamingEnumeration<SearchResult> enumeration = LdapContextOperationWrapper.from(this.env).searchAndClose(searchFilterExpr, parameters, searchControls);
        return new SearchMultivalueResultIterator(enumeration, searchControls);
    }

    public Iterator<Map<String, String>> search(String searchFilterExpr, Object[] parameters, SearchControls searchControls) throws LdapClientException {
        try {
            try {
                return this.trySearch(searchFilterExpr, parameters, searchControls);
            }
            catch (CommunicationException ce) {
                LOG.warn((Object)"Problem communicating with LDAP server, retrying.", (Throwable)ce);
                return this.trySearch(searchFilterExpr, parameters, searchControls);
            }
        }
        catch (NamingException ne) {
            throw new LdapClientException("LDAP search failed.", ne);
        }
    }

    public Iterator<Map<String, Set<String>>> searchMultivalues(String searchFilterExpr, Object[] parameters, SearchControls searchControls) throws LdapClientException {
        try {
            try {
                return this.trySearchMultivalues(searchFilterExpr, parameters, searchControls);
            }
            catch (CommunicationException ce) {
                LOG.warn((Object)"Problem communicating with LDAP server, retrying.", (Throwable)ce);
                return this.trySearchMultivalues(searchFilterExpr, parameters, searchControls);
            }
        }
        catch (NamingException ne) {
            throw new LdapClientException("LDAP search failed.", ne);
        }
    }

    private static LdapClientException wrapNamingException(String ldapUrl, NamingException ex) {
        return new LdapClientException("Failed to create LDAP context " + ldapUrl + ": " + ex.getExplanation(), ex);
    }

    public String getADUserDn(final String sAMAccountName) throws LdapClientException {
        return this.executeWitReconnect(new LdapCommand<String>(){

            @Override
            public String execute() throws NamingException, LdapClientException {
                String searchFilter = "(&(objectClass=user)(sAMAccountName={0}))";
                SearchControls searchCtls = new SearchControls();
                searchCtls.setReturningAttributes(new String[0]);
                searchCtls.setSearchScope(2);
                NamingEnumeration<SearchResult> result = LdapContextOperationWrapper.from(LdapConnection.this.env).searchAndClose(searchFilter, new Object[]{sAMAccountName}, searchCtls);
                String dn = null;
                if (result.hasMoreElements()) {
                    dn = ((SearchResult)result.nextElement()).getNameInNamespace();
                }
                return dn;
            }
        });
    }

    public Set<String> getADUserGroups(String sAMAccountName) throws LdapClientException {
        String userDn = this.getADUserDn(sAMAccountName);
        if (userDn == null) {
            return Collections.emptySet();
        }
        HashSet<String> groups = new HashSet<String>();
        SearchControls userSearchCtls = new SearchControls();
        userSearchCtls.setSearchScope(0);
        userSearchCtls.setReturningAttributes(new String[]{"tokenGroups"});
        try {
            NamingEnumeration userAnswer = LdapContextOperationWrapper.from(this.env).searchBasedOnNamespacesAndClose(userDn, userSearchCtls);
            StringBuilder groupsSearchFilter = new StringBuilder();
            groupsSearchFilter.append("(|");
            while (userAnswer.hasMoreElements()) {
                SearchResult sr = (SearchResult)userAnswer.nextElement();
                Attributes attrs = sr.getAttributes();
                if (attrs == null) continue;
                NamingEnumeration<? extends Attribute> ae = attrs.getAll();
                while (ae.hasMoreElements()) {
                    Attribute attr = (Attribute)ae.nextElement();
                    NamingEnumeration<?> e = attr.getAll();
                    while (e.hasMoreElements()) {
                        byte[] sid = (byte[])e.nextElement();
                        groupsSearchFilter.append("(objectSid=" + LdapConnection.binarySidToStringSid(sid) + ")");
                    }
                }
            }
            groupsSearchFilter.append(")");
            SearchControls groupsSearchCtls = new SearchControls();
            groupsSearchCtls.setSearchScope(2);
            groupsSearchCtls.setReturningAttributes(new String[]{"sAMAccountName"});
            NamingEnumeration<SearchResult> groupsAnswer = LdapContextOperationWrapper.from(this.env).searchAndClose(groupsSearchFilter.toString(), groupsSearchCtls);
            while (groupsAnswer.hasMoreElements()) {
                SearchResult sr = (SearchResult)groupsAnswer.nextElement();
                Attributes attrs = sr.getAttributes();
                if (attrs == null) continue;
                groups.add(attrs.get("sAMAccountName").get().toString());
            }
        }
        catch (NamingException e) {
            throw new LdapClientException("", e);
        }
        return groups;
    }

    public static String binarySidToStringSid(byte[] SID) {
        String strSID = "";
        strSID = "S";
        long version = SID[0];
        strSID = strSID + "-" + Long.toString(version);
        long authority = SID[4];
        for (int i = 0; i < 4; ++i) {
            authority <<= 8;
            authority += (long)(SID[4 + i] & 0xFF);
        }
        strSID = strSID + "-" + Long.toString(authority);
        long count = SID[2];
        count <<= 8;
        count += (long)(SID[1] & 0xFF);
        int j = 0;
        while ((long)j < count) {
            long rid = SID[11 + j * 4] & 0xFF;
            for (int k = 1; k < 4; ++k) {
                rid <<= 8;
                rid += (long)(SID[11 - k + j * 4] & 0xFF);
            }
            strSID = strSID + "-" + Long.toString(rid);
            ++j;
        }
        return strSID;
    }

    private <T> T executeWitReconnect(LdapCommand<T> ldapCommand) throws LdapClientException {
        return this.executeWitReconnect(ldapCommand, 2);
    }

    private <T> T executeWitReconnect(LdapCommand<T> ldapCommand, int retryCount) throws LdapClientException {
        T result;
        try {
            result = ldapCommand.execute();
        }
        catch (CommunicationException e) {
            if (retryCount > 1) {
                result = this.executeWitReconnect(ldapCommand, retryCount - 1);
            }
            throw new LdapClientException("", e);
        }
        catch (NamingException e) {
            throw new LdapClientException("", e);
        }
        return result;
    }

    public Hashtable<String, String> getEnv() {
        return this.env;
    }

    private static interface LdapCommand<T> {
        public T execute() throws NamingException, LdapClientException;
    }

    private static class SearchMultivalueResultIterator
    implements Iterator<Map<String, Set<String>>> {
        private final NamingEnumeration<SearchResult> enumeration;
        private final SearchControls searchControls;

        SearchMultivalueResultIterator(NamingEnumeration<SearchResult> enumeration, SearchControls searchControls) {
            this.enumeration = enumeration;
            this.searchControls = searchControls;
        }

        @Override
        public boolean hasNext() {
            return this.enumeration.hasMoreElements();
        }

        @Override
        public Map<String, Set<String>> next() {
            try {
                return this.createMapFromSearchResult((SearchResult)this.enumeration.nextElement());
            }
            catch (NamingException e) {
                throw new UnhandledException((Throwable)e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private Map<String, Set<String>> createMapFromSearchResult(SearchResult searchResult) throws NamingException {
            NamingEnumeration<? extends Attribute> attribEnum = searchResult.getAttributes().getAll();
            CaseInsensitiveMap attributes = new CaseInsensitiveMap();
            while (attribEnum.hasMoreElements()) {
                Attribute attribute = (Attribute)attribEnum.nextElement();
                String attributeName = attribute.getID();
                NamingEnumeration<?> attributeValuesEnum = attribute.getAll();
                HashSet attributeValues = new HashSet();
                while (attributeValuesEnum.hasMoreElements()) {
                    attributeValues.add(attributeValuesEnum.nextElement());
                }
                attributes.put(attributeName, Collections.unmodifiableSet(attributeValues));
            }
            return attributes;
        }
    }

    private static class SearchResultIterator
    implements Iterator<Map<String, String>> {
        private final NamingEnumeration<SearchResult> enumeration;
        private final SearchControls searchControls;

        SearchResultIterator(NamingEnumeration<SearchResult> enumeration, SearchControls searchControls) {
            this.enumeration = enumeration;
            this.searchControls = searchControls;
        }

        @Override
        public boolean hasNext() {
            return this.enumeration.hasMoreElements();
        }

        @Override
        public Map<String, String> next() {
            try {
                return this.createMapFromSearchResult((SearchResult)this.enumeration.nextElement());
            }
            catch (NamingException e) {
                throw new UnhandledException((Throwable)e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private Map<String, String> createMapFromSearchResult(SearchResult searchResult) throws NamingException {
            NamingEnumeration<? extends Attribute> attribEnum = searchResult.getAttributes().getAll();
            CaseInsensitiveMap attributes = new CaseInsensitiveMap();
            while (attribEnum.hasMoreElements()) {
                Attribute attribute = (Attribute)attribEnum.nextElement();
                String attributeName = attribute.getID();
                String attributeValue = attribute.get().toString();
                attributes.put(attributeName, attributeValue);
            }
            if (!attributes.containsKey(LdapConnection.DISTINGUISHED_NAME)) {
                boolean includeDistinguishedName;
                boolean bl = includeDistinguishedName = null != this.searchControls && this.searchControls.getReturningObjFlag() && (null == this.searchControls.getReturningAttributes() || ArrayUtils.contains((Object[])this.searchControls.getReturningAttributes(), (Object)LdapConnection.DISTINGUISHED_NAME));
                if (includeDistinguishedName) {
                    DirContext dirContext = (DirContext)searchResult.getObject();
                    String distinguishedName = dirContext.getNameInNamespace();
                    attributes.put(LdapConnection.DISTINGUISHED_NAME, distinguishedName);
                }
            }
            return attributes;
        }
    }
}

