package com.imcode.net.ldap;

public class LdapClient {

    private final String ldapUrl;

    public LdapClient(String ldapUrl) {
        this.ldapUrl = ldapUrl;
    }

    public boolean canBind(String userDistinguishedName, String password) throws LdapClientException {
        return LdapContextOperationWrapper
                .checkConnection(bind(userDistinguishedName, password).getEnv());
    }

    public LdapConnection bind(String ldapBindDn, String ldapPassword) throws LdapClientException {
        return new LdapConnection(ldapUrl, ldapBindDn, ldapPassword);
    }

    public String getLdapUrl() {
        return ldapUrl;
    }

}
