/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.net.ldap;

import com.imcode.net.ldap.LdapAuthenticationException;
import com.imcode.net.ldap.LdapClientException;
import java.util.Hashtable;
import javax.naming.AuthenticationException;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.LdapName;

class LdapContextOperationWrapper {
    private LdapContext ctx;
    private final Hashtable<String, String> env;

    private LdapContextOperationWrapper(Hashtable<String, String> env) throws LdapClientException {
        this.env = env;
        this.createLdapContext();
    }

    static LdapContextOperationWrapper from(Hashtable<String, String> env) throws LdapClientException {
        return new LdapContextOperationWrapper(env);
    }

    static boolean checkConnection(Hashtable<String, String> env) throws LdapClientException {
        try {
            new LdapContextOperationWrapper(env).ctx.close();
        }
        catch (AuthenticationException ae) {
            return false;
        }
        catch (NamingException e) {
            throw new LdapClientException("", e);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NamingEnumeration<SearchResult> searchAndClose(String searchFilterExpr, Object[] parameters, SearchControls searchControls) throws NamingException {
        try {
            NamingEnumeration<SearchResult> namingEnumeration = this.ctx.search("", searchFilterExpr, parameters, searchControls);
            return namingEnumeration;
        }
        finally {
            this.ctx.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NamingEnumeration<SearchResult> searchAndClose(String searchFilterExpr, SearchControls searchControls) throws NamingException {
        try {
            NamingEnumeration<SearchResult> namingEnumeration = this.ctx.search("", searchFilterExpr, searchControls);
            return namingEnumeration;
        }
        finally {
            this.ctx.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NamingEnumeration searchBasedOnNamespacesAndClose(String userDn, SearchControls userSearchCtls) throws NamingException {
        try {
            LdapName userDnName = new LdapName(userDn);
            LdapName ctxName = new LdapName(this.ctx.getNameInNamespace());
            Name name = userDnName.getSuffix(ctxName.size());
            NamingEnumeration<SearchResult> namingEnumeration = this.ctx.search(name, "(objectClass=user)", userSearchCtls);
            return namingEnumeration;
        }
        finally {
            this.ctx.close();
        }
    }

    private void createLdapContext() throws LdapClientException {
        try {
            this.ctx = new InitialLdapContext(this.env, null);
        }
        catch (AuthenticationException ex) {
            throw new LdapAuthenticationException("Authentication failed, using login: '" + this.env.get("java.naming.security.principal") + "'", ex);
        }
        catch (NameNotFoundException ex) {
            throw new LdapClientException("Root not found: " + this.env.get("java.naming.provider.url"), ex);
        }
        catch (NamingException ex) {
            throw this.wrapNamingException(this.env.get("java.naming.provider.url"), ex);
        }
    }

    private LdapClientException wrapNamingException(String ldapUrl, NamingException ex) {
        return new LdapClientException("Failed to create LDAP context " + ldapUrl + ": " + ex.getExplanation(), ex);
    }
}

