/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.net.ldap;

import com.imcode.net.ldap.LdapAuthenticationException;
import com.imcode.net.ldap.LdapClientException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.naming.AuthenticationException;
import javax.naming.CommunicationException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.commons.collections.map.CaseInsensitiveMap;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.UnhandledException;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapConnection {
    private static final Logger LOG = Logger.getLogger(LdapConnection.class);
    private static final String AUTHENTICATION_TYPE_SIMPLE = "simple";
    private static final String DISTINGUISHED_NAME = "dn";
    private final String ldapUrl;
    private final String ldapBindDn;
    private final String ldapPassword;
    private DirContext ctx;

    public LdapConnection(String ldapUrl, String ldapBindDn, String ldapPassword) throws LdapClientException {
        this.ldapUrl = ldapUrl;
        this.ldapBindDn = ldapBindDn;
        this.ldapPassword = ldapPassword;
        this.connect();
    }

    private void connect() throws LdapClientException {
        InitialDirContext result;
        try {
            result = new InitialDirContext(LdapConnection.createLdapJndiEnvironment(this.ldapUrl, this.ldapBindDn, this.ldapPassword));
        }
        catch (AuthenticationException ex) {
            throw new LdapAuthenticationException("Authentication failed, using login: '" + this.ldapBindDn + "'", ex);
        }
        catch (NameNotFoundException ex) {
            throw new LdapClientException("Root not found: " + this.ldapUrl, ex);
        }
        catch (NamingException ex) {
            throw LdapConnection.wrapNamingException(this.ldapUrl, ex);
        }
        this.ctx = result;
    }

    private static Hashtable createLdapJndiEnvironment(String ldapUrl, String ldapBindDn, String ldapPassword) {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", ldapUrl);
        env.put("java.naming.security.authentication", AUTHENTICATION_TYPE_SIMPLE);
        env.put("java.naming.security.principal", ldapBindDn);
        env.put("java.naming.security.credentials", ldapPassword);
        env.put("java.naming.referral", "follow");
        return env;
    }

    private Iterator<Map<String, String>> trySearch(String searchFilterExpr, Object[] parameters, SearchControls searchControls) throws NamingException {
        if (null == searchControls) {
            searchControls = new SearchControls();
        }
        searchControls.setReturningObjFlag(true);
        NamingEnumeration<SearchResult> enumeration = this.ctx.search("", searchFilterExpr, parameters, searchControls);
        return new SearchResultIterator(enumeration, searchControls);
    }

    public Iterator<Map<String, String>> search(String searchFilterExpr, Object[] parameters, SearchControls searchControls) throws LdapClientException {
        try {
            try {
                return this.trySearch(searchFilterExpr, parameters, searchControls);
            }
            catch (CommunicationException ce) {
                LOG.warn((Object)"Problem communicating with LDAP server, retrying.", (Throwable)ce);
                this.connect();
                return this.trySearch(searchFilterExpr, parameters, searchControls);
            }
        }
        catch (NamingException ne) {
            throw new LdapClientException("LDAP search failed.", ne);
        }
    }

    public void close() {
        try {
            this.ctx.close();
        }
        catch (NamingException ne) {
            LOG.debug((Object)"Closing context failed.", (Throwable)ne);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    private static LdapClientException wrapNamingException(String ldapUrl, NamingException ex) {
        return new LdapClientException("Failed to create LDAP context " + ldapUrl + ": " + ex.getExplanation(), ex);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SearchResultIterator
    implements Iterator<Map<String, String>> {
        private final NamingEnumeration<SearchResult> enumeration;
        private final SearchControls searchControls;

        SearchResultIterator(NamingEnumeration<SearchResult> enumeration, SearchControls searchControls) {
            this.enumeration = enumeration;
            this.searchControls = searchControls;
        }

        @Override
        public boolean hasNext() {
            try {
                return this.enumeration.hasMore();
            }
            catch (NamingException e) {
                throw new UnhandledException((Throwable)e);
            }
        }

        @Override
        public Map<String, String> next() {
            try {
                return this.createMapFromSearchResult(this.enumeration.next());
            }
            catch (NamingException e) {
                throw new UnhandledException((Throwable)e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private Map<String, String> createMapFromSearchResult(SearchResult searchResult) throws NamingException {
            NamingEnumeration<? extends Attribute> attribEnum = searchResult.getAttributes().getAll();
            CaseInsensitiveMap attributes = new CaseInsensitiveMap();
            while (attribEnum.hasMoreElements()) {
                Attribute attribute = (Attribute)attribEnum.nextElement();
                String attributeName = attribute.getID();
                String attributeValue = attribute.get().toString();
                attributes.put(attributeName, attributeValue);
            }
            if (!attributes.containsKey(LdapConnection.DISTINGUISHED_NAME)) {
                boolean includeDistinguishedName;
                boolean bl = includeDistinguishedName = null != this.searchControls && this.searchControls.getReturningObjFlag() && (null == this.searchControls.getReturningAttributes() || ArrayUtils.contains((Object[])this.searchControls.getReturningAttributes(), (Object)LdapConnection.DISTINGUISHED_NAME));
                if (includeDistinguishedName) {
                    DirContext dirContext = (DirContext)searchResult.getObject();
                    String distinguishedName = dirContext.getNameInNamespace();
                    attributes.put(LdapConnection.DISTINGUISHED_NAME, distinguishedName);
                }
            }
            return attributes;
        }
    }
}

