package com.imcode.net.ldap;

import junit.framework.TestCase;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

import org.apache.commons.lang.StringUtils;

import javax.naming.directory.SearchControls;

public class LdapConnectionTest extends TestCase {

    private LdapConnection ldapConnection;
    private Properties testProperties;

    protected void setUp() throws Exception {
        super.setUp();
        String property = System.getProperty("test.properties");
        if ( StringUtils.isBlank(property) ) {
            return;
        }
        testProperties = new Properties();
        testProperties.load(new FileInputStream(property));

        ldapConnection = getLdapConnection();
    }

    public void testSimpleSearch() throws LdapClientException, IOException {
        if (null == ldapConnection) {
            return ;
        }
        String ldapObjectClass = testProperties.getProperty("ldap.objectclass");
        String ldapExpectedAttributeName = testProperties.getProperty("ldap.expected.attribute.name");
        String ldapExpectedAttributeValue = testProperties.getProperty("ldap.expected.attribute.value");
        assertSimpleSearchSuccess(ldapObjectClass, ldapExpectedAttributeName, ldapExpectedAttributeValue);
    }

    private void assertSimpleSearchSuccess(String ldapObjectClass, String ldapExpectedAttributeName,
                                           String ldapExpectedAttributeValue) throws LdapClientException {
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(SearchControls.SUBTREE_SCOPE);
        Iterator<Map<String,String>> result = ldapConnection.search("(&(objectClass={0})({1}={2}))",
                                                                    new Object[] { ldapObjectClass, ldapExpectedAttributeName, ldapExpectedAttributeValue },
                                                                    searchControls);
        assertTrue(result.hasNext());
        Map<String,String> map = result.next();
        assertTrue(map.containsKey(ldapExpectedAttributeName));
        assertEquals(ldapExpectedAttributeValue, map.get(ldapExpectedAttributeName));
    }

    private LdapConnection getLdapConnection() throws LdapClientException {
        String ldapUrl = testProperties.getProperty("ldap.url");
        String ldapBindDn = testProperties.getProperty("ldap.bind.dn");
        String ldapPassword = testProperties.getProperty("ldap.bind.password");

        LdapClient ldapClient = new LdapClient(ldapUrl);
        return ldapClient.bind(ldapBindDn, ldapPassword);
    }
}
