/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.net.ldap;

import com.imcode.net.ldap.LdapAuthenticationException;
import com.imcode.net.ldap.LdapClientException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.AuthenticationException;
import javax.naming.CommunicationException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapConnection {
    private static final Logger LOG = Logger.getLogger(LdapConnection.class);
    private static final String AUTHENTICATION_TYPE_SIMPLE = "simple";
    private final DirContext ctx;
    public static final String DISTINGUISHED_NAME = "dn";

    public LdapConnection(String ldapUrl, String ldapBindDn, String ldapPassword) throws LdapClientException {
        try {
            this.ctx = new InitialDirContext(LdapConnection.createLdapJndiEnvironment(ldapUrl, ldapBindDn, ldapPassword));
        }
        catch (AuthenticationException ex) {
            throw new LdapAuthenticationException("Authentication failed, using login: '" + ldapBindDn + "'", ex);
        }
        catch (NameNotFoundException ex) {
            throw new LdapClientException("Root not found: " + ldapUrl, ex);
        }
        catch (NamingException ex) {
            throw LdapConnection.wrapNamingException(ldapUrl, ex);
        }
    }

    private static Hashtable createLdapJndiEnvironment(String ldapUrl, String ldapBindDn, String ldapPassword) {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", ldapUrl);
        env.put("java.naming.security.authentication", AUTHENTICATION_TYPE_SIMPLE);
        env.put("java.naming.security.principal", ldapBindDn);
        env.put("java.naming.security.credentials", ldapPassword);
        return env;
    }

    private Map<String, String> trySearch(String searchFilterExpr, Object[] parameters, SearchControls searchControls) throws NamingException {
        NamingEnumeration<SearchResult> enumeration = this.ctx.search("", searchFilterExpr, parameters, searchControls);
        if (enumeration != null && enumeration.hasMore()) {
            SearchResult searchResult = (SearchResult)enumeration.nextElement();
            return this.createMapFromSearchResult(searchResult, searchControls.getReturningAttributes());
        }
        return null;
    }

    private Map<String, String> createMapFromSearchResult(SearchResult searchResult, String[] attributesToReturn) {
        NamingEnumeration<? extends Attribute> attribEnum = searchResult.getAttributes().getAll();
        HashMap<String, String> attributes = new HashMap<String, String>();
        try {
            if (!attribEnum.hasMore()) {
                boolean includeDistinguishedName;
                boolean bl = includeDistinguishedName = null == attributesToReturn || ArrayUtils.contains((Object[])attributesToReturn, (Object)DISTINGUISHED_NAME);
                if (includeDistinguishedName) {
                    DirContext dirContext = (DirContext)searchResult.getObject();
                    String distinguishedName = dirContext.getNameInNamespace();
                    attributes.put(DISTINGUISHED_NAME, distinguishedName);
                }
            }
        }
        catch (NamingException e) {
            LOG.error((Object)e);
        }
        while (attribEnum.hasMoreElements()) {
            Attribute attribute = (Attribute)attribEnum.nextElement();
            String attributeName = attribute.getID();
            String attributeValue = null;
            try {
                attributeValue = attribute.get().toString();
            }
            catch (NamingException e) {
                LOG.error((Object)e);
            }
            attributes.put(attributeName, attributeValue);
        }
        return attributes;
    }

    public Map<String, String> search(String searchFilterExpr, Object[] parameters, SearchControls searchControls) throws LdapClientException {
        try {
            try {
                return this.trySearch(searchFilterExpr, parameters, searchControls);
            }
            catch (CommunicationException ce) {
                LOG.warn((Object)"Problem communicating with LDAP server, retrying.", (Throwable)ce);
                return this.trySearch(searchFilterExpr, parameters, searchControls);
            }
        }
        catch (NamingException ne) {
            throw new LdapClientException("LDAP search failed.", ne);
        }
    }

    public void close() {
        try {
            this.ctx.close();
        }
        catch (NamingException ne) {
            LOG.debug((Object)"Closing context failed.", (Throwable)ne);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    private static LdapClientException wrapNamingException(String ldapUrl, NamingException ex) {
        return new LdapClientException("Failed to create LDAP context " + ldapUrl + ": " + ex.getExplanation(), ex);
    }
}

