/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.search;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.imcode.search.SearchCriteria;
import com.imcode.search.SearchOperation;
import java.util.LinkedList;
import java.util.List;
import javax.validation.constraints.NotNull;

public class SearchCriteries {
    private List<SearchCriteriaResult> searchCriteriaResults;
    private String orderBy;
    private Order order;

    private SearchCriteries() {
    }

    public static SearchCriteries select() {
        SearchCriteries builder = new SearchCriteries();
        builder.searchCriteriaResults = new LinkedList<SearchCriteriaResult>();
        return builder;
    }

    public static SearchCriteries orderedSelect(@NotNull String orderBy, @NotNull Order order) {
        SearchCriteries builder = new SearchCriteries();
        builder.searchCriteriaResults = new LinkedList<SearchCriteriaResult>();
        builder.orderBy = orderBy;
        builder.order = order;
        return builder;
    }

    public List<SearchCriteriaResult> where(@NotNull String fieldName, @NotNull SearchOperation so, @NotNull Object value) {
        SearchCriteria searchCriteria = new SearchCriteria(fieldName, so, value);
        SearchCriteriaResult result = this.buildSearchCriteriaResult(searchCriteria);
        if (this.orderBy != null && this.order != null) {
            result.orderBy = this.orderBy;
            result.order = this.order;
        }
        this.searchCriteriaResults.add(result);
        return this.searchCriteriaResults;
    }

    public SearchCriteries whereAnd(@NotNull String fieldName, @NotNull SearchOperation so, @NotNull Object value) {
        SearchCriteria searchCriteria = new SearchCriteria(fieldName, so, value);
        SearchCriteriaResult result = this.buildSearchCriteriaResult(searchCriteria);
        result.nextAnd = true;
        this.searchCriteriaResults.add(result);
        return this;
    }

    public SearchCriteries whereOr(@NotNull String fieldName, @NotNull SearchOperation so, @NotNull Object value) {
        SearchCriteria searchCriteria = new SearchCriteria(fieldName, so, value);
        SearchCriteriaResult result = this.buildSearchCriteriaResult(searchCriteria);
        result.nextAnd = false;
        this.searchCriteriaResults.add(result);
        return this;
    }

    private SearchCriteriaResult buildSearchCriteriaResult(SearchCriteria searchCriteria) {
        SearchCriteriaResult result = new SearchCriteriaResult();
        result.fieldName = searchCriteria.getFieldName();
        result.operation = searchCriteria.getOperation();
        String valueAsJson = null;
        try {
            valueAsJson = new ObjectMapper().writeValueAsString(searchCriteria.getValue());
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        result.value = valueAsJson;
        result.valueType = searchCriteria.getValue().getClass();
        result.order = this.order;
        result.orderBy = this.orderBy;
        return result;
    }

    public static class SearchCriteriaResult {
        private String fieldName;
        private SearchOperation operation;
        private String value;
        private Class<?> valueType;
        private Boolean nextAnd;
        private String orderBy;
        private Order order;

        public String getFieldName() {
            return this.fieldName;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public SearchOperation getOperation() {
            return this.operation;
        }

        public void setOperation(SearchOperation operation) {
            this.operation = operation;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public Class<?> getValueType() {
            return this.valueType;
        }

        public void setValueType(Class<?> valueType) {
            this.valueType = valueType;
        }

        public Boolean getNextAnd() {
            return this.nextAnd;
        }

        public void setNextAnd(Boolean nextAnd) {
            this.nextAnd = nextAnd;
        }

        public String getOrderBy() {
            return this.orderBy;
        }

        public void setOrderBy(String orderBy) {
            this.orderBy = orderBy;
        }

        public Order getOrder() {
            return this.order;
        }

        public void setOrder(Order order) {
            this.order = order;
        }
    }

    public static enum Order {
        ASC,
        DESC;

    }
}

