/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.controllers.html;

import com.imcode.entities.OnceTimeAccessToken;
import com.imcode.entities.Person;
import com.imcode.entities.Role;
import com.imcode.entities.User;
import com.imcode.entities.embed.Email;
import com.imcode.entities.embed.Phone;
import com.imcode.entities.enums.CommunicationTypeEnum;
import com.imcode.oauth2.IvisClientDetailsService;
import com.imcode.services.OnceTimeAccessTokenService;
import com.imcode.services.PersonService;
import com.imcode.services.RoleService;
import com.imcode.services.UserService;
import com.imcode.utils.MailSenderUtil;
import com.imcode.utils.StaticUtls;
import java.security.Principal;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.token.ConsumerTokenServices;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AdminController {
    @Autowired
    private ConsumerTokenServices tokenServices;
    @Autowired
    private TokenStore tokenStore;
    @Autowired
    private IvisClientDetailsService clientDetailsService;
    @Value(value="${Hibernate.dialect}")
    private String test;
    @Autowired
    private UserService userService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private PersonService personService;
    @Autowired
    private JavaMailSender mailSender;
    @Autowired
    public OnceTimeAccessTokenService onceTimeAccessTokenService;
    @Value(value="${Server.name}")
    private String serverName;

    @RequestMapping(value={"/oauth/users/{user}/tokens/{token}"}, method={RequestMethod.DELETE})
    public ResponseEntity<Void> revokeToken(@PathVariable String user, @PathVariable String token, Principal principal) throws Exception {
        this.checkResourceOwner(user, principal);
        if (this.tokenServices.revokeToken(token)) {
            return new ResponseEntity(HttpStatus.NO_CONTENT);
        }
        return new ResponseEntity(HttpStatus.NOT_FOUND);
    }

    @RequestMapping(value={"/oauth/clients/{client}/tokens"})
    @ResponseBody
    public Collection<OAuth2AccessToken> listTokensForClient(@PathVariable String client) throws Exception {
        return this.tokenStore.findTokensByClientId(client);
    }

    @RequestMapping(value={"/oauth/tokens"}, method={RequestMethod.GET})
    public String tokenList(Model model) {
        IvisClientDetailsService ClientDetailsService2 = this.clientDetailsService;
        List clients = this.clientDetailsService.listClientDetails();
        LinkedList tokens = new LinkedList();
        for (ClientDetails clientDetails : clients) {
            Collection tokensByClientId = this.tokenStore.findTokensByClientId(clientDetails.getClientId());
            if (tokensByClientId == null) continue;
            tokens.addAll(tokensByClientId);
        }
        model.addAttribute("tokens", tokens);
        return "tokens";
    }

    @RequestMapping(value={"/oauth/tokens/{tokenVlue}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public boolean delete(@PathVariable(value="tokenVlue") String tokenValue) {
        return this.tokenServices.revokeToken(tokenValue);
    }

    @RequestMapping(value={"/login"})
    public ModelAndView login(@RequestParam(value="display", required=false) String display, WebRequest webRequest, ModelAndView model) {
        boolean isPopup;
        boolean bl = isPopup = display != null && "popup".equals(display);
        if (isPopup) {
            model.setViewName("security/login_popup");
        } else {
            model.setViewName("security/login");
        }
        return model;
    }

    @RequestMapping(value={"/registration"})
    public ModelAndView registration(WebRequest webRequest, ModelAndView model) {
        User user = new User();
        model.addObject((Object)user);
        model.setViewName("security/registration");
        return model;
    }

    @RequestMapping(value={"/registration/do"})
    public ModelAndView registrationDo(@ModelAttribute(value="user") User user, @RequestParam(value="firstName") String firstName, @RequestParam(value="lastName") String lastName, @RequestParam(value="email") String email, @RequestParam(value="contactPhone") String contactPhone, WebRequest webRequest, ModelAndView model) {
        Person person = new Person();
        person.setFirstName(firstName);
        person.setLastName(lastName);
        Email emailPerson = new Email();
        emailPerson.setValue(email);
        person.setEmail(emailPerson);
        Phone phone = new Phone();
        phone.setValue(contactPhone);
        person.setPhone(phone);
        user.setPerson(person);
        StaticUtls.encodeUserPassword(user);
        OnceTimeAccessToken token = OnceTimeAccessToken.genToken((User)user, (int)1440, (OnceTimeAccessToken.TokenType)OnceTimeAccessToken.TokenType.VERIFICATION);
        this.onceTimeAccessTokenService.save((Object)token);
        String link = StaticUtls.genLinkConfirmationForOnceTimeAccessToken(token, this.serverName, "registration");
        String to = email;
        String subject = "Registration confirmation in iVIS";
        String text = "Thank you, " + user.getUsername() + " for registration in iVIS." + " Please follow link to confirm registration: " + link;
        MailSenderUtil mailSenderUtil = new MailSenderUtil(this.mailSender, false, false);
        mailSenderUtil.createMessage(to, subject, text);
        mailSenderUtil.sendMessage();
        model.setViewName("redirect:/login");
        return model;
    }

    @RequestMapping(value={"/registration/confirm"}, method={RequestMethod.GET})
    public ModelAndView registrationConfirm(@RequestParam(value="access") String access, @RequestParam(value="id") Long id, WebRequest webRequest, ModelAndView model) {
        OnceTimeAccessToken accessToken = (OnceTimeAccessToken)this.onceTimeAccessTokenService.find((Object)id);
        String message = StaticUtls.checkOnceTimeAccessToken(accessToken, access);
        if (message != null) {
            model.addObject((Object)message);
            model.setViewName("redirect:/oauth_error");
            return model;
        }
        User user = (User)accessToken.getUser();
        user.setEnabled(Boolean.valueOf(true));
        Role roleUser = (Role)this.roleService.findFirstByName("ROLE_USER");
        HashSet<Role> roles = new HashSet<Role>();
        roles.add(roleUser);
        user.setRoles(roles);
        Person person = (Person)this.personService.save((Object)user.getPerson());
        user.setPerson(person);
        this.userService.save((Object)user);
        accessToken.setUsed(Boolean.valueOf(true));
        this.onceTimeAccessTokenService.save((Object)accessToken);
        String to = ((Email)user.getPerson().getEmails().get(CommunicationTypeEnum.HOME)).getValue();
        String subject = "Registration complete success";
        String text = "Now you, " + user.getUsername() + " can use iVIS system." + " You can log in " + this.serverName + "/login using your username and password.";
        MailSenderUtil mailSenderUtil = new MailSenderUtil(this.mailSender, false, false);
        mailSenderUtil.createMessage(to, subject, text);
        mailSenderUtil.sendMessage();
        model.setViewName("redirect:/login");
        return model;
    }

    @RequestMapping(value={"/registration/emailunique"}, method={RequestMethod.GET})
    @ResponseBody
    public Boolean registrationEmailCheck(@RequestParam(value="email") String email, WebRequest webRequest, ModelAndView model) {
        User userByEmail = this.userService.findByEmail(email);
        return userByEmail == null;
    }

    @RequestMapping(value={"/registration/usernameunique"}, method={RequestMethod.GET})
    @ResponseBody
    public Boolean registrationUsernameCheck(@RequestParam(value="username") String username, WebRequest webRequest, ModelAndView model) {
        User userByName = this.userService.findByUsername(username);
        return userByName == null;
    }

    @RequestMapping(value={"/restore_password"})
    public ModelAndView restorePassword(WebRequest webRequest, ModelAndView model) {
        model.setViewName("security/restore_password");
        return model;
    }

    @RequestMapping(value={"/restore_password/email"}, method={RequestMethod.POST})
    public ModelAndView restorePasswordEmail(@RequestParam(value="email") String email, WebRequest webRequest, ModelAndView model) {
        User userByEmail = this.userService.findByEmail(email);
        OnceTimeAccessToken accessToken = OnceTimeAccessToken.genToken((User)userByEmail, (int)1440, (OnceTimeAccessToken.TokenType)OnceTimeAccessToken.TokenType.PASSWORD_RESET);
        this.onceTimeAccessTokenService.save((Object)accessToken);
        String link = StaticUtls.genLinkConfirmationForOnceTimeAccessToken(accessToken, this.serverName, "restore_password");
        String to = email;
        String subject = "Restore password in iVIS";
        String text = "Hello, " + userByEmail.getUsername() + ". For restore password in iVIS" + " please follow link  " + link;
        MailSenderUtil mailSenderUtil = new MailSenderUtil(this.mailSender, false, false);
        mailSenderUtil.createMessage(to, subject, text);
        mailSenderUtil.sendMessage();
        model.setViewName("redirect:/login");
        return model;
    }

    @RequestMapping(value={"/restore_password/confirm"}, method={RequestMethod.GET})
    public ModelAndView restorePasswordConfirm(@RequestParam(value="access") String access, @RequestParam(value="id") Long id, WebRequest webRequest, ModelAndView model) {
        OnceTimeAccessToken accessToken = (OnceTimeAccessToken)this.onceTimeAccessTokenService.find((Object)id);
        String message = StaticUtls.checkOnceTimeAccessToken(accessToken, access);
        if (message != null) {
            model.addObject((Object)message);
            model.setViewName("redirect:/oauth_error");
            return model;
        }
        accessToken.setUsed(Boolean.valueOf(true));
        this.onceTimeAccessTokenService.save((Object)accessToken);
        User user = (User)accessToken.getUser();
        model.addObject("user", (Object)user);
        model.setViewName("security/restore_password");
        return model;
    }

    @RequestMapping(value={"/restore_password/do"}, method={RequestMethod.POST})
    public ModelAndView restorePasswordDo(@RequestParam(value="password") String password, @RequestParam(value="userId") Long userId, WebRequest webRequest, ModelAndView model) {
        User user = (User)this.userService.find((Object)userId);
        user.setPassword(password);
        StaticUtls.encodeUserPassword(user);
        this.userService.save((Object)user);
        String to = ((Email)user.getPerson().getEmails().get(CommunicationTypeEnum.HOME)).getValue();
        String subject = "Restore password in iVIS";
        String text = "Hello, " + user.getUsername() + ". Your password has bean changed.";
        MailSenderUtil mailSenderUtil = new MailSenderUtil(this.mailSender, false, false);
        mailSenderUtil.createMessage(to, subject, text);
        mailSenderUtil.sendMessage();
        model.setViewName("redirect:/login");
        return model;
    }

    @RequestMapping(value={"/restore_password/emailunique"}, method={RequestMethod.GET})
    @ResponseBody
    public Boolean restorePasswordEmailCheck(@RequestParam(value="email") String email, WebRequest webRequest, ModelAndView model) {
        return this.registrationEmailCheck(email, webRequest, model);
    }

    @RequestMapping(value={"/", "/home", "index"})
    public String home() {
        return "default";
    }

    private void checkResourceOwner(String user, Principal principal) {
        OAuth2Authentication authentication;
        if (principal instanceof OAuth2Authentication && !(authentication = (OAuth2Authentication)principal).isClientOnly() && !user.equals(principal.getName())) {
            throw new AccessDeniedException(String.format("User '%s' cannot obtain tokens for user '%s'", principal.getName(), user));
        }
    }

    @PostConstruct
    public void deleteExpiredOrUsedOnceTimeAccessTokens() {
        List onceTimeAccessTokens = this.onceTimeAccessTokenService.selectExpiredOrUsedTokens();
        this.onceTimeAccessTokenService.delete((Iterable)onceTimeAccessTokens);
    }

    public void setTokenServices(ConsumerTokenServices tokenServices) {
        this.tokenServices = tokenServices;
    }

    public void setTokenStore(TokenStore tokenStore) {
        this.tokenStore = tokenStore;
    }

    public void setClientDetailsService(IvisClientDetailsService clientDetailsService) {
        this.clientDetailsService = clientDetailsService;
    }
}

