/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.controllers.html.tiles.preparers;

import com.imcode.entities.interfaces.JpaEntity;
import java.util.LinkedList;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.persistence.EntityManager;
import javax.persistence.metamodel.EntityType;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.tiles.Attribute;
import org.apache.tiles.AttributeContext;
import org.apache.tiles.ListAttribute;
import org.apache.tiles.context.TilesRequestContext;
import org.apache.tiles.preparer.ViewPreparerSupport;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.data.repository.support.Repositories;
import org.springframework.stereotype.Component;

@Component
public class MenuPreparer
extends ViewPreparerSupport {
    @Autowired
    private EntityManager entityManager;
    @Autowired
    private ApplicationContext context;
    private Repositories repositories;

    public void execute(TilesRequestContext tilesContext, AttributeContext attributeContext) {
        LinkedList<ImmutablePair> menuMap = new LinkedList<ImmutablePair>();
        Set entityTypes = this.entityManager.getMetamodel().getEntities();
        for (EntityType entityType : entityTypes) {
            Class entityClass = entityType.getJavaType();
            String entityClassName = entityClass.getSimpleName();
            if (JpaEntity.class.isAssignableFrom(entityClass) && this.repositories.hasRepositoryFor(entityClass)) {
                menuMap.add(new ImmutablePair((Object)entityClassName, (Object)("/domain/" + entityClassName)));
            }
            boolean bl = false;
        }
        attributeContext.putAttribute("menuMap", (Attribute)new ListAttribute(menuMap), true);
    }

    @PostConstruct
    public void init() {
        this.repositories = new Repositories((ListableBeanFactory)this.context);
    }

    class MenuPair {
        MenuPair() {
        }
    }
}

