/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.saml2.store;

import java.util.HashSet;
import java.util.Set;
import org.opensaml.common.IdentifierGenerator;
import org.opensaml.common.impl.RandomIdentifierGenerator;

public final class SAMLRequestStore {
    private Set<String> samlRequestStorage = new HashSet<String>();
    private IdentifierGenerator identifierGenerator = new RandomIdentifierGenerator();
    private static SAMLRequestStore instance = new SAMLRequestStore();

    private SAMLRequestStore() {
    }

    public static SAMLRequestStore getInstance() {
        return instance;
    }

    public synchronized void storeRequest(String key) {
        if (this.samlRequestStorage.contains(key)) {
            throw new RuntimeException("SAML request storage has already contains key " + key);
        }
        this.samlRequestStorage.add(key);
    }

    public synchronized String storeRequest() {
        String key = null;
        while (this.samlRequestStorage.contains(key = this.identifierGenerator.generateIdentifier(20))) {
        }
        this.storeRequest(key);
        return key;
    }

    public synchronized boolean exists(String key) {
        return this.samlRequestStorage.contains(key);
    }

    public synchronized void removeRequest(String key) {
        this.samlRequestStorage.remove(key);
    }
}

