/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.utils;

import com.imcode.entities.SchemaVersion;
import com.imcode.utils.StaticUtls;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.io.FileUtils;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.multipart.MultipartFile;

public class DatabaseWorker {
    private BasicDataSource dataSource;
    private SchemaVersion schemaVersion;
    private ServletContext servletContext;

    public DatabaseWorker(BasicDataSource dataSource, SchemaVersion schemaVersion, ServletContext servletContext) {
        this.dataSource = dataSource;
        this.schemaVersion = schemaVersion;
        this.servletContext = servletContext;
    }

    public boolean runScript(MultipartFile multipartFile) {
        String fileName = this.genFileNametOf(this.schemaVersion, TypeSQL.SCRIPT);
        this.saveScriptToFile(multipartFile, fileName);
        return this.execute(fileName, TypeSQL.SCRIPT);
    }

    public void createVersionDump() {
        String fileName = this.genFileNametOf(this.schemaVersion, TypeSQL.DUMP);
        File file = new File(fileName);
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.execute(fileName, TypeSQL.DUMP);
    }

    public void migrateToVersion() {
        String fileName = this.genFileNametOf(this.schemaVersion, TypeSQL.DUMP);
        this.dropCreateDB();
        this.execute(fileName, TypeSQL.SCRIPT);
    }

    public void saveVersionDumpInResponse(HttpServletResponse httpServletResponse) {
        boolean needDeleteTemp = false;
        if (this.schemaVersion == null) {
            this.schemaVersion = new SchemaVersion();
            this.schemaVersion.setVersion("temp");
            needDeleteTemp = true;
            this.createVersionDump();
        }
        String fileName = this.genFileNametOf(this.schemaVersion, TypeSQL.DUMP);
        File initialFile = new File(fileName);
        httpServletResponse.setContentType("application/force-download");
        httpServletResponse.setContentLength((int)initialFile.length());
        httpServletResponse.setHeader("Content-Transfer-Encoding", "binary");
        httpServletResponse.setHeader("Content-Disposition", "attachment; filename=\"" + initialFile.getName() + "\"");
        BufferedInputStream targetStream = null;
        try {
            targetStream = new BufferedInputStream(new FileInputStream(initialFile));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        try {
            FileCopyUtils.copy((InputStream)targetStream, (OutputStream)httpServletResponse.getOutputStream());
            httpServletResponse.flushBuffer();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (needDeleteTemp) {
            initialFile.delete();
        }
    }

    public void deleteVersion() {
        String fileName = this.genFileNametOf(this.schemaVersion, TypeSQL.SCRIPT);
        String path = fileName.substring(0, fileName.lastIndexOf(47));
        try {
            FileUtils.deleteDirectory((File)new File(path));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean execute(String fileName, TypeSQL type) {
        String url = this.dataSource.getUrl();
        String dbName = url.substring(url.lastIndexOf(47) + 1, url.lastIndexOf(63));
        StringBuilder command = new StringBuilder(type.equals((Object)TypeSQL.SCRIPT) ? "mysql" : "mysqldump");
        command.append(" -u ");
        command.append(this.dataSource.getUsername());
        command.append(" -p");
        command.append(this.dataSource.getPassword());
        command.append(" ");
        command.append(dbName);
        command.append(type.equals((Object)TypeSQL.SCRIPT) ? " < " : " > ");
        command.append(fileName);
        return StaticUtls.executeCmd(command.toString());
    }

    private void saveScriptToFile(MultipartFile multipartFile, String fileName) {
        File script = new File(fileName);
        script.getParentFile().mkdirs();
        try {
            script.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            multipartFile.transferTo(script);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String genFileNametOf(SchemaVersion schemaVersion, TypeSQL type) {
        String version = schemaVersion.getVersion();
        StringBuilder path = new StringBuilder(this.servletContext.getRealPath("/WEB-INF/"));
        path.append("schema-versions/");
        path.append(version + "/");
        path.append((Object)((Object)type) + "_" + version + ".sql");
        return path.toString();
    }

    private void dropCreateDB() {
        String url = this.dataSource.getUrl();
        String dbName = url.substring(url.lastIndexOf("/") + 1, url.length());
        StringBuilder path = new StringBuilder(this.servletContext.getRealPath("/WEB-INF/"));
        path.append("schema-versions/");
        path.append("temp/");
        path.append("createDrop.sql");
        File file = new File(path.toString());
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            BufferedWriter bw = null;
            try {
                bw = new BufferedWriter(new FileWriter(file));
                bw.write("DROP DATABASE IF EXISTS " + dbName + ";");
                bw.write("CREATE SCHEMA " + dbName + ";");
                bw.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.execute(file.getAbsolutePath(), TypeSQL.SCRIPT);
    }

    private static enum TypeSQL {
        SCRIPT("script"),
        DUMP("dump");

        private String typeSQL;

        private TypeSQL(String typeSQL) {
            this.typeSQL = typeSQL;
        }

        public String toString() {
            return this.typeSQL;
        }
    }
}

