/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.saml2;

import com.imcode.saml2.AuthenticationMethodConfiguration;
import com.imcode.saml2.Imcms;
import java.util.Map;

public class FilterConfig {
    public static final String EXCLUDED_URL_PATTERN_PARAMETER = "excludedUrlPattern";
    public static final String SP_ACS_URL_PARAMETER = "acsUrl";
    public static final String SP_ID_PARAMETER = "spProviderId";
    public static final String SP_LOGOUT_URL_PARAMETER = "logoutUrl";
    public static final String AUTHENTICATION_METHOD_NAME_PROP = "cgi";
    private String excludedUrlPattern;
    private String acsUrl;
    private String spProviderId;
    private String logoutUrl;
    private String idpSSOUrl;
    private Boolean isEnabled;

    public FilterConfig(javax.servlet.FilterConfig config) {
        Map<String, AuthenticationMethodConfiguration> configurationMap = Imcms.getAuthenticationConfiguration();
        this.isEnabled = configurationMap.containsKey(AUTHENTICATION_METHOD_NAME_PROP);
        this.excludedUrlPattern = config.getInitParameter(EXCLUDED_URL_PATTERN_PARAMETER);
        this.spProviderId = Imcms.getServerName();
        this.acsUrl = this.spProviderId + config.getServletContext().getContextPath() + "/acs";
        this.idpSSOUrl = this.isEnabled != false ? configurationMap.get(AUTHENTICATION_METHOD_NAME_PROP).getUrl() : "";
        this.logoutUrl = config.getInitParameter(SP_LOGOUT_URL_PARAMETER);
    }

    public String getExcludedUrlPattern() {
        return this.excludedUrlPattern;
    }

    public String getSpProviderId() {
        return this.spProviderId;
    }

    public String getIdpSSOUrl() {
        return this.idpSSOUrl;
    }

    public String getLogoutUrl() {
        return this.logoutUrl;
    }

    public String getAcsUrl() {
        return this.acsUrl;
    }

    public Boolean isEnabled() {
        return this.isEnabled;
    }
}

